"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routingStatus = exports.routingDefinitionSchema = exports.routingDefinitionListSchema = exports.isRoutingEnabled = void 0;
var _streamlang = require("@kbn/streamlang");
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routingStatus = exports.routingStatus = _zod.z.enum(['enabled', 'disabled']);
const routingDefinitionSchema = exports.routingDefinitionSchema = _zod.z.object({
  destination: _zodHelpers.NonEmptyString,
  where: _streamlang.conditionSchema,
  status: routingStatus.optional()
});
const routingDefinitionListSchema = exports.routingDefinitionListSchema = _zod.z.array(routingDefinitionSchema);
const isRoutingEnabled = exports.isRoutingEnabled = (0, _zodHelpers.createIsNarrowSchema)(routingStatus, _zod.z.literal('enabled'));