"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServerRoute = void 0;
var _serverRouteRepository = require("@kbn/server-route-repository");
var _boom = require("@hapi/boom");
var _elasticsearch = require("@elastic/elasticsearch");
var _lodash = require("lodash");
var _status_error = require("../lib/streams/errors/status_error");
var _aggregate_status_error = require("../lib/streams/errors/aggregate_status_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPlainStreamsServerRoute = (0, _serverRouteRepository.createServerRouteFactory)();
const createServerRoute = ({
  handler,
  ...config
}) => {
  var _config$options$tags, _config$options;
  return createPlainStreamsServerRoute({
    ...config,
    options: {
      ...config.options,
      tags: [...((_config$options$tags = (_config$options = config.options) === null || _config$options === void 0 ? void 0 : _config$options.tags) !== null && _config$options$tags !== void 0 ? _config$options$tags : []), 'oas-tag:streams']
    },
    handler: options => {
      const {
        telemetry
      } = options;
      const finishTracking = telemetry.startTrackingEndpointLatency({
        name: (0, _lodash.get)(options, 'params.path.name', '__all__'),
        endpoint: config.endpoint
      });
      return handler(options).catch(error => {
        const isStreamsStateError = error instanceof _status_error.StatusError || error instanceof _aggregate_status_error.AggregateStatusError;
        if (isStreamsStateError) {
          telemetry.reportStreamsStateError(error);
        }
        if (isStreamsStateError || error instanceof _elasticsearch.errors.ResponseError) {
          switch (error.statusCode) {
            case 400:
              throw (0, _boom.badRequest)(error, 'data' in error ? error.data : undefined);
            case 403:
              throw (0, _boom.forbidden)(error, 'data' in error ? error.data : undefined);
            case 404:
              throw (0, _boom.notFound)(error, 'data' in error ? error.data : undefined);
            case 409:
              throw (0, _boom.conflict)(error, 'data' in error ? error.data : undefined);
            case 500:
              throw (0, _boom.internal)(error, 'data' in error ? error.data : undefined);
          }
        }
        throw error;
      }).finally(finishTracking);
    }
  });
};
exports.createServerRoute = createServerRoute;