"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidStateError = void 0;
var _aggregate_status_error = require("../../errors/aggregate_status_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InvalidStateError extends _aggregate_status_error.AggregateStatusError {
  constructor(errors, message) {
    let overallMessage = message;
    if (errors.length > 0) {
      overallMessage += `: ${errors.map(error => error.message).join(', ')}`;
    }
    super(errors, overallMessage, 400);
    this.name = 'InvalidStateError';
  }
}
exports.InvalidStateError = InvalidStateError;