"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateReroutePipeline = generateReroutePipeline;
var _streamlang = require("@kbn/streamlang");
var _constants = require("../../../../common/constants");
var _name = require("./name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateReroutePipeline({
  definition
}) {
  return {
    id: (0, _name.getReroutePipelineName)(definition.name),
    processors: definition.ingest.wired.routing.filter(child => child.status !== 'disabled').map(child => {
      return {
        reroute: {
          destination: child.destination,
          if: (0, _streamlang.conditionToPainless)(child.where)
        }
      };
    }),
    _meta: {
      description: `Reroute pipeline for the ${definition.name} stream`,
      managed: true
    },
    version: _constants.ASSET_VERSION
  };
}