"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStreamTypeFromDefinition = getStreamTypeFromDefinition;
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStreamTypeFromDefinition(definition) {
  if (_streamsSchema.Streams.WiredStream.Definition.is(definition)) {
    return 'wired';
  }
  if (_streamsSchema.Streams.ClassicStream.Definition.is(definition)) {
    return 'classic';
  }
  return 'unknown';
}