"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamsAppRouter = void 0;
var _i18n = require("@kbn/i18n");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _streams_app_page_template = require("../components/streams_app_page_template");
var _streams_app_router_breadcrumb = require("../components/streams_app_router_breadcrumb");
var _redirect_to = require("../components/redirect_to");
var _stream_list_view = require("../components/stream_list_view");
var _stream_root = require("../components/stream_root");
var _stream_detail_management = require("../components/data_management/stream_detail_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/routes/config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The array of route definitions to be used when the application
 * creates the routes.
 */
const streamsAppRoutes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_streams_app_router_breadcrumb.StreamsAppRouterBreadcrumb, {
      title: _i18n.i18n.translate('xpack.streams.appBreadcrumbTitle', {
        defaultMessage: 'Streams'
      }),
      path: "/",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }))),
    children: {
      '/': {
        element: /*#__PURE__*/_react.default.createElement(_stream_list_view.StreamListView, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 18
          }
        })
      },
      '/{key}': {
        element: /*#__PURE__*/_react.default.createElement(_stream_root.StreamDetailRoot, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 43,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 44,
            columnNumber: 13
          }
        })),
        params: t.type({
          path: t.type({
            key: t.string
          })
        }),
        children: {
          '/{key}': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              path: "/{key}/management/{tab}",
              params: {
                path: {
                  tab: 'retention'
                }
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 55,
                columnNumber: 15
              }
            })
          },
          /**
           * This route matching the StreamDetailView will be temporarily disable as it does not provide additional value than the stream list and retention view
           */
          // '/{key}/{tab}': {
          //   element: <StreamDetailView />,
          //   params: t.type({
          //     path: t.type({
          //       tab: t.string,
          //     }),
          //   }),
          // },
          /**
           * This route is added as a replacement of the old StreamDetailView routing to redirect from existing overview/dashboard links into the management page
           */
          '/{key}/{tab}': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              path: "/{key}/management/{tab}",
              params: {
                path: {
                  tab: 'retention'
                }
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 74,
                columnNumber: 15
              }
            }),
            params: t.type({
              path: t.type({
                tab: t.string
              })
            })
          },
          '/{key}/management/{tab}': {
            element: /*#__PURE__*/_react.default.createElement(_stream_detail_management.StreamDetailManagement, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 83,
                columnNumber: 22
              }
            }),
            params: t.type({
              path: t.type({
                tab: t.string
              })
            })
          }
        }
      }
    }
  }
};
const streamsAppRouter = exports.streamsAppRouter = (0, _typedReactRouterConfig.createRouter)(streamsAppRoutes);