"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDescription = StreamDescription;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_stream_detail = require("../../hooks/use_stream_detail");
var _use_update_streams = require("../../hooks/use_update_streams");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_view/description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.streams.streamDescription.emptyDescriptionLabel', {
  defaultMessage: 'Add a description'
});
function StreamDescription({
  definition
}) {
  const {
    refresh
  } = (0, _use_stream_detail.useStreamDetail)();
  const updateStream = (0, _use_update_streams.useUpdateStreams)(definition.stream.name);
  const [description, setDescription] = (0, _react.useState)(definition.stream.description);
  (0, _react.useEffect)(() => {
    setDescription(definition.stream.description);
  }, [definition.stream.description]);
  const onChange = e => {
    setDescription(e.target.value);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    "data-test-subj": "streamDescriptionEdit",
    css: (0, _react2.css)`
          .euiButtonEmpty {
            block-size: auto;
            white-space: normal;
            overflow: visible;
            vertical-align: baseline;
            text-align: start;
          }

          .eui-textTruncate {
            overflow: visible !important;
            text-overflow: clip !important;
            white-space: normal !important;
          }
        `,
    editModeProps: {
      inputProps: {},
      formRowProps: {},
      saveButtonProps: {
        color: 'primary'
      },
      cancelButtonProps: {
        display: 'empty'
      }
    },
    isReadOnly: definition.privileges.manage !== true,
    placeholder: EMPTY_DESCRIPTION_LABEL,
    value: description,
    onChange: onChange,
    onCancel: previousValue => {
      setDescription(previousValue);
    },
    inputAriaLabel: _i18n.i18n.translate('xpack.streams.streamDescription.inputAriaLabel', {
      defaultMessage: 'Edit Stream description'
    }),
    size: "xs",
    onSave: async value => {
      const sanitized = value.trim();
      setDescription(sanitized);
      await updateStream({
        queries: definition.queries,
        dashboards: definition.dashboards,
        stream: {
          ...(0, _lodash.omit)(definition.stream, ['name']),
          description: sanitized
        }
      });
      refresh();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
}