"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailSignificantEventsView = StreamDetailSignificantEventsView;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_filtered_sig_events = require("./hooks/use_filtered_sig_events");
var _use_kibana = require("../../hooks/use_kibana");
var _edit_significant_event_flyout = require("./edit_significant_event_flyout");
var _preview_data_spark_plot = require("./add_significant_event_flyout/common/preview_data_spark_plot");
var _use_fetch_significant_events = require("../../hooks/use_fetch_significant_events");
var _use_significant_events_api = require("../../hooks/use_significant_events_api");
var _use_timefilter = require("../../hooks/use_timefilter");
var _loading_panel = require("../loading_panel");
var _empty_state = require("./empty_state/empty_state");
var _significant_events_table = require("./significant_events_table");
var _default_query = require("./add_significant_event_flyout/utils/default_query");
var _no_features = require("./empty_state/no_features");
var _stream_features_flyout = require("../data_management/stream_detail_management/stream_features/stream_features_flyout");
var _use_stream_features = require("../data_management/stream_detail_management/stream_features/hooks/use_stream_features");
var _use_stream_features_api = require("../../hooks/use_stream_features_api");
var _use_ai_features = require("./add_significant_event_flyout/generated_flow_form/use_ai_features");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StreamDetailSignificantEventsView({
  definition
}) {
  var _significantEventsFet;
  const {
    timeState: {
      start,
      end
    },
    setTime
  } = (0, _use_timefilter.useTimefilter)();
  const {
    unifiedSearch
  } = (0, _use_kibana.useKibana)().dependencies.start;
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const xFormatter = (0, _react.useMemo)(() => {
    return (0, _charts.niceTimeFormatter)([start, end]);
  }, [start, end]);
  const {
    features,
    refreshFeatures,
    featuresLoading
  } = (0, _use_stream_features.useStreamFeatures)(definition.stream);
  const {
    identifyFeatures,
    abort
  } = (0, _use_stream_features_api.useStreamFeaturesApi)(definition.stream);
  const [isFeatureDetectionFlyoutOpen, setIsFeatureDetectionFlyoutOpen] = (0, _react.useState)(false);
  const [isFeatureDetectionLoading, setIsFeatureDetectionLoading] = (0, _react.useState)(false);
  const [detectedFeatures, setDetectedFeatures] = (0, _react.useState)([]);
  const significantEventsFetchState = (0, _use_fetch_significant_events.useFetchSignificantEvents)({
    name: definition.stream.name,
    start,
    end
  });
  const {
    removeQuery
  } = (0, _use_significant_events_api.useSignificantEventsApi)({
    name: definition.stream.name,
    start,
    end
  });
  const [isEditFlyoutOpen, setIsEditFlyoutOpen] = (0, _react.useState)(false);
  const [initialFlow, setInitialFlow] = (0, _react.useState)('ai');
  const [selectedFeatures, setSelectedFeatures] = (0, _react.useState)([]);
  const [queryToEdit, setQueryToEdit] = (0, _react.useState)();
  const [query, setQuery] = (0, _react.useState)('');
  const {
    significantEvents,
    combinedQuery
  } = (0, _use_filtered_sig_events.useFilteredSigEvents)((_significantEventsFet = significantEventsFetchState.value) !== null && _significantEventsFet !== void 0 ? _significantEventsFet : [], query);
  (0, _react.useEffect)(() => {
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get(_constants.OPEN_SIGNIFICANT_EVENTS_FLYOUT_URL_PARAM) === 'true' && features.length > 0) {
      setIsEditFlyoutOpen(true);

      // Parse selected features from URL parameters
      const selectedFeaturesParam = urlParams.get(_constants.SELECTED_FEATURES_URL_PARAM);
      if (selectedFeaturesParam) {
        const selectedFeatureNames = selectedFeaturesParam.split(',').filter(name => name.trim());
        setSelectedFeatures(features.filter(feature => selectedFeatureNames.includes(feature.name)));
      }

      // Clean up the URL parameters after opening the flyout
      const newUrl = new URL(window.location.href);
      newUrl.searchParams.delete(_constants.OPEN_SIGNIFICANT_EVENTS_FLYOUT_URL_PARAM);
      newUrl.searchParams.delete(_constants.SELECTED_FEATURES_URL_PARAM);
      window.history.replaceState({}, '', newUrl.toString());
    }
  }, [features]);
  if (featuresLoading || significantEventsFetchState.loading) {
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 12
      }
    });
  }
  const featureDetectionFlyout = isFeatureDetectionFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_stream_features_flyout.StreamFeaturesFlyout, {
    definition: definition.stream,
    features: detectedFeatures,
    isLoading: isFeatureDetectionLoading,
    closeFlyout: () => {
      abort();
      refreshFeatures();
      setIsFeatureDetectionFlyoutOpen(false);
    },
    setFeatures: setDetectedFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }) : null;
  const editFlyout = /*#__PURE__*/_react.default.createElement(_edit_significant_event_flyout.EditSignificantEventFlyout, {
    setIsEditFlyoutOpen: setIsEditFlyoutOpen,
    isEditFlyoutOpen: isEditFlyoutOpen,
    definition: definition,
    refresh: significantEventsFetchState.refresh,
    queryToEdit: queryToEdit,
    setQueryToEdit: setQueryToEdit,
    initialFlow: initialFlow,
    selectedFeatures: selectedFeatures,
    setSelectedFeatures: setSelectedFeatures,
    features: features,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  });
  const noFeatures = features.length === 0;
  const noSignificantEvents = significantEventsFetchState.value && significantEventsFetchState.value.length === 0;
  if (noFeatures && noSignificantEvents) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_no_features.NoFeaturesEmptyState, {
      onFeatureIdentificationClick: () => {
        setIsFeatureDetectionLoading(true);
        setIsFeatureDetectionFlyoutOpen(true);
        identifyFeatures(aiFeatures === null || aiFeatures === void 0 ? void 0 : aiFeatures.genAiConnectors.selectedConnector, 'now', 'now-24h').then(data => {
          setDetectedFeatures(data.features);
        }).finally(() => {
          setIsFeatureDetectionLoading(false);
        });
      },
      onManualEntryClick: () => {
        setQueryToEdit(undefined);
        setInitialFlow('manual');
        setIsEditFlyoutOpen(true);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }), featureDetectionFlyout, editFlyout);
  }
  if (noSignificantEvents) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_empty_state.NoSignificantEventsEmptyState, {
      onGenerateSuggestionsClick: () => {
        setInitialFlow('ai');
        setIsEditFlyoutOpen(true);
      },
      onManualEntryClick: () => {
        setQueryToEdit(undefined);
        setInitialFlow('manual');
        setIsEditFlyoutOpen(true);
      },
      features: features,
      selectedFeatures: selectedFeatures,
      onFeaturesChange: setSelectedFeatures,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }), editFlyout);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(unifiedSearch.ui.SearchBar, {
    appName: "streamsApp",
    showFilterBar: false,
    showQueryMenu: false,
    showQueryInput: true,
    submitButtonStyle: "iconOnly",
    displayStyle: "inPage",
    disableQueryLanguageSwitcher: true,
    onRefresh: q => {
      significantEventsFetchState.refresh();
      setTime(q.dateRange);
    },
    onQuerySubmit: queryN => {
      var _queryN$query$query, _queryN$query;
      setQuery(String((_queryN$query$query = (_queryN$query = queryN.query) === null || _queryN$query === void 0 ? void 0 : _queryN$query.query) !== null && _queryN$query$query !== void 0 ? _queryN$query$query : ''));
      setTime(queryN.dateRange);
    },
    onQueryChange: queryN => {
      var _queryN$query$query2, _queryN$query2;
      setQuery(String((_queryN$query$query2 = (_queryN$query2 = queryN.query) === null || _queryN$query2 === void 0 ? void 0 : _queryN$query2.query) !== null && _queryN$query$query2 !== void 0 ? _queryN$query$query2 : ''));
      setTime(queryN.dateRange);
    },
    query: {
      query,
      language: 'text'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    color: "primary",
    onClick: () => {
      setIsEditFlyoutOpen(true);
      setQueryToEdit(undefined);
    },
    iconType: "plus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.addSignificantEventButton', {
    defaultMessage: 'Significant events'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_preview_data_spark_plot.PreviewDataSparkPlot, {
    definition: definition.stream,
    query: {
      kql: {
        query: combinedQuery !== null && combinedQuery !== void 0 ? combinedQuery : ''
      },
      id: 'preview_all',
      title: 'All events'
    },
    isQueryValid: true,
    noOfBuckets: 50,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_significant_events_table.SignificantEventsTable, {
    loading: significantEventsFetchState.loading,
    definition: definition.stream,
    items: significantEvents,
    onEditClick: item => {
      var _item$query$feature;
      setIsEditFlyoutOpen(true);
      setQueryToEdit({
        ...item.query,
        feature: (_item$query$feature = item.query.feature) !== null && _item$query$feature !== void 0 ? _item$query$feature : _default_query.NO_FEATURE
      });
    },
    onDeleteClick: async item => {
      await (removeQuery === null || removeQuery === void 0 ? void 0 : removeQuery(item.query.id).then(() => {
        significantEventsFetchState.refresh();
      }));
    },
    xFormatter: xFormatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  }))), editFlyout);
}