"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesSelector = FeaturesSelector;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/feature_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FeaturesSelector({
  features,
  selectedFeatures,
  onFeaturesChange
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        fontWeight: euiTheme.font.weight.semiBold
      },
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.significantEvents.featuresSelector.featuresLabel', {
      defaultMessage: 'Select features'
    })),
    css: {
      width: '100%',
      maxWidth: 450
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.streams.significantEvents.featuresSelector.featuresPlaceholder', {
      defaultMessage: 'Select features'
    }),
    options: features.map(feature => ({
      label: feature.name,
      value: feature
    })),
    selectedOptions: selectedFeatures.map(feature => ({
      label: feature.name,
      value: feature
    })),
    onChange: selected => {
      onFeaturesChange(selected.map(option => option.value));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })));
}