"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewDataSparkPlot = PreviewDataSparkPlot;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/discover-plugin/common");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_timefilter = require("../../../../hooks/use_timefilter");
var _spark_plot = require("../../../spark_plot");
var _use_significant_event_preview_fetch = require("../manual_flow_form/use_significant_event_preview_fetch");
var _use_spark_plot_data_from_sig_events = require("../manual_flow_form/use_spark_plot_data_from_sig_events");
var _asset_image = require("../../../asset_image");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/common/preview_data_spark_plot.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PreviewDataSparkPlot({
  query,
  definition,
  isQueryValid,
  showTitle = true,
  compressed = false,
  hideAxis = false,
  height,
  noOfBuckets
}) {
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const previewFetch = (0, _use_significant_event_preview_fetch.useSignificantEventPreviewFetch)({
    name: definition.name,
    feature: query.feature,
    kqlQuery: query.kql.query,
    timeState,
    isQueryValid,
    noOfBuckets
  });
  const xFormatter = (0, _react.useMemo)(() => {
    return (0, _charts.niceTimeFormatter)([timeState.start, timeState.end]);
  }, [timeState.start, timeState.end]);
  const sparkPlotData = (0, _use_spark_plot_data_from_sig_events.useSparkplotDataFromSigEvents)({
    previewFetch,
    queryValues: query,
    xFormatter
  });
  const noOccurrencesFound = sparkPlotData.timeseries.every(point => point.y === 0);
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const useUrl = share.url.locators.useUrl;
  const discoverLink = useUrl(() => ({
    id: _common.DISCOVER_APP_LOCATOR,
    params: {
      query: {
        esql: isQueryValid ? (0, _streamsSchema.buildEsqlQuery)((0, _streamsSchema.getIndexPatternsForStream)(definition), query) : ''
      }
    }
  }), [definition, query, isQueryValid]);
  function renderContent() {
    if (isQueryValid === false) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "barChart",
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "s",
        textAlign: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.previewChartPrompt', {
        defaultMessage: 'Preview will appear here'
      })));
    }
    if (previewFetch.loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 14
        }
      });
    }
    if (previewFetch.error) {
      if (compressed) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "cross",
          color: "danger",
          size: "l",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 16
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "cross",
        color: "danger",
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        textAlign: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.previewChartError', {
        defaultMessage: 'Failed to load preview data'
      })));
    }
    if (noOccurrencesFound) {
      if (compressed) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "visLine",
          color: euiTheme.colors.disabled,
          size: "l",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 16
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "barChart",
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "s",
        textAlign: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.previewChartNoData', {
        defaultMessage: 'No events found, make sure to review your query'
      })));
    }
    const openInDiscoverLabel = _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.previewChartOpenInDiscover', {
      defaultMessage: 'Open in Discover'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      css: {
        width: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        fontWeight: euiTheme.font.weight.semiBold
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.previewChartDetectedOccurrences', {
      defaultMessage: 'Detected event occurrences ({count})',
      values: {
        count: sparkPlotData.timeseries.reduce((acc, point) => acc + point.y, 0)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": openInDiscoverLabel,
      iconType: "discoverApp",
      href: discoverLink,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    }, openInDiscoverLabel))), /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
      id: "query_preview",
      name: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.previewChartSeriesName', {
        defaultMessage: 'Occurrences'
      }),
      type: "bar",
      timeseries: sparkPlotData.timeseries,
      annotations: sparkPlotData.annotations,
      xFormatter: xFormatter,
      compressed: compressed,
      hideAxis: hideAxis,
      height: height,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: !compressed,
    hasShadow: false,
    css: {
      height: height ? height : '200px'
    },
    paddingSize: compressed ? 'none' : 'm',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "center",
    css: {
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, renderContent()));
}