"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamStatsPanel = StreamStatsPanel;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _ilm_link = require("../../data_management/stream_detail_lifecycle/general_data/ilm_link");
var _format_bytes = require("../../data_management/stream_detail_lifecycle/helpers/format_bytes");
var _use_data_stream_stats = require("../../data_management/stream_detail_lifecycle/hooks/use_data_stream_stats");
var _insufficient_privileges = require("../../insufficient_privileges/insufficient_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_overview/components/stream_stats_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RetentionDisplay = ({
  definition
}) => {
  if (!definition) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-");
  if ((0, _streamsSchema.isDslLifecycle)(definition.effective_lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (definition === null || definition === void 0 ? void 0 : definition.effective_lifecycle.dsl.data_retention) || _i18n.i18n.translate('xpack.streams.entityDetailOverview.unlimited', {
      defaultMessage: 'Keep indefinitely'
    }));
  }
  if ((0, _streamsSchema.isIlmLifecycle)(definition.effective_lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_ilm_link.IlmLink, {
      lifecycle: definition.effective_lifecycle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-");
};
const StatItem = ({
  label,
  value,
  withBorder = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const borderStyle = withBorder ? (0, _css.css)`
        border-left: 1px solid ${euiTheme.colors.borderBaseSubdued};
        padding-left: ${euiTheme.size.s};
      ` : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: borderStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    className: (0, _css.css)`
            font-weight: bold;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, value)));
};
function StreamStatsPanel({
  definition
}) {
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const data = (0, _use_data_stream_stats.useDataStreamStats)({
    definition,
    timeState
  }).stats;
  const retentionLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.retention', {
    defaultMessage: 'Data retention'
  });
  const documentCountLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.count', {
    defaultMessage: 'Document count'
  });
  const storageSizeLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.size', {
    defaultMessage: 'Storage size'
  });
  const ingestionLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.ingestion', {
    defaultMessage: 'Ingestion'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, retentionLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(RetentionDisplay, {
    definition: definition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StatItem, {
    label: documentCountLabel,
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: _i18n.i18n.translate('xpack.streams.streamStatsPanel.privilegesWarningIconWrapper.totaldoccountLabel', {
        defaultMessage: 'Total doc count'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 17
      }
    }, data ? (0, _eui.formatNumber)(data.ds.stats.totalDocs || 0, 'decimal0') : '-'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(StatItem, {
    label: storageSizeLabel,
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: _i18n.i18n.translate('xpack.streams.streamStatsPanel.privilegesWarningIconWrapper.sizebytesLabel', {
        defaultMessage: 'Size in bytes'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }, data && data.ds.stats.sizeBytes ? (0, _format_bytes.formatBytes)(data.ds.stats.sizeBytes) : '-'),
    withBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(StatItem, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ingestionLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRateDetails', {
        defaultMessage: 'Approximate average (stream total size divided by the number of days since creation).'
      }),
      position: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 19
      }
    })),
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: _i18n.i18n.translate('xpack.streams.streamStatsPanel.privilegesWarningIconWrapper.ingestionrateLabel', {
        defaultMessage: 'Ingestion rate'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 17
      }
    }, data !== null && data !== void 0 && data.ds.stats ? (0, _format_bytes.formatIngestionRate)(data.ds.stats.bytesPerDay || 0, true) : '-'),
    withBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  })))));
}