"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedbackButton = FeedbackButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/feedback_button/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const STREAMS_FEEDBACK_URL = 'https://ela.st/feedback-streams-ui';
function FeedbackButton() {
  const {
    isServerless,
    dependencies: {
      start: {
        cloud
      }
    },
    services: {
      version
    }
  } = (0, _use_kibana.useKibana)();
  const deploymentType = isServerless ? 'Serverless' : cloud !== null && cloud !== void 0 && cloud.isCloudEnabled ? 'Cloud' : 'Self-Managed';
  const path = window.location.pathname;
  const queryParams = new URLSearchParams({
    environment: deploymentType,
    version,
    path
  });
  const feedbackUrl = `${STREAMS_FEEDBACK_URL}?${queryParams.toString()}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "popout",
    href: feedbackUrl,
    target: "_blank",
    rel: "noopener",
    iconSide: "right",
    "aria-label": _i18n.i18n.translate('xpack.streams.feedbackButtonLabel', {
      defaultMessage: 'Give feedback'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.streams.feedbackButtonLabel', {
    defaultMessage: 'Give feedback'
  }));
}