"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentMatchFilterControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../util/formatters");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/document_match_filter_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const percentageFormatter = (0, _formatters.getPercentageFormatter)({
  precision: 1
});
const DocumentMatchFilterControls = ({
  onFilterChange,
  matchedDocumentPercentage,
  isDisabled = false
}) => {
  const documentMatchFilter = (0, _stream_routing_state_machine.useStreamSamplesSelector)(snapshot => snapshot.context.documentMatchFilter);
  const handleFilterChanged = (0, _react.useCallback)(value => {
    if (value === documentMatchFilter) return;
    onFilterChange(value);
  }, [documentMatchFilter, onFilterChange]);
  const hasNoValue = isDisabled || matchedDocumentPercentage === undefined || matchedDocumentPercentage === null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "routingPreviewFilterControls",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    compressed: true,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetail.preview.filter.matchedAriaLabel', {
      defaultMessage: 'Filter for matched documents.'
    }),
    "data-test-subj": "routingPreviewMatchedFilterButton",
    hasActiveFilters: documentMatchFilter === 'matched',
    onClick: () => handleFilterChanged('matched'),
    isDisabled: hasNoValue,
    isSelected: documentMatchFilter === 'matched',
    badgeColor: "success",
    grow: false,
    isToggle: true,
    numActiveFilters: hasNoValue ? '' : percentageFormatter.format(matchedDocumentPercentage),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.filter.matched', {
    defaultMessage: 'Matched'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetail.preview.filter.unmatchedAriaLabel', {
      defaultMessage: 'Filter for unmatched documents.'
    }),
    "data-test-subj": "routingPreviewUnmatchedFilterButton",
    hasActiveFilters: documentMatchFilter === 'unmatched',
    onClick: () => handleFilterChanged('unmatched'),
    isDisabled: hasNoValue,
    isSelected: documentMatchFilter === 'unmatched',
    badgeColor: "accent",
    grow: false,
    isToggle: true,
    numActiveFilters: hasNoValue ? '' : percentageFormatter.format(Math.max(1 - matchedDocumentPercentage, 0)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.filter.unmatched', {
    defaultMessage: 'Unmatched'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "routingPreviewFilterControlsTooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamRouting.previewMatchesTooltipAriaLabel', {
      defaultMessage: 'Additional information'
    }),
    type: 'question',
    content: _i18n.i18n.translate('xpack.streams.streamDetail.previewMatchesTooltipText', {
      defaultMessage: 'Approximate percentage of documents matching/unmatching the condition over a random sample of documents.'
    }),
    iconProps: {
      style: {
        verticalAlign: 'text-bottom',
        marginLeft: 2
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }))));
};
exports.DocumentMatchFilterControls = DocumentMatchFilterControls;