"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamFeatureDetailsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _shared = require("../../shared");
var _feature_events_data = require("./feature_events_data");
var _use_stream_features_api = require("../../../../hooks/use_stream_features_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_features/stream_feature_details_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StreamFeatureDetailsFlyout = ({
  feature,
  definition,
  closeFlyout,
  refreshFeatures
}) => {
  const [featureDescription, setFeatureDescription] = _react.default.useState(feature.description);
  const {
    upsertQuery
  } = (0, _use_stream_features_api.useStreamFeaturesApi)(definition);
  const [isUpdating, setIsUpdating] = _react.default.useState(false);
  const [featureFilter, setFeatureFilter] = _react.default.useState(feature.filter);
  const [isEditingCondition, toggleIsEditingCondition] = (0, _useToggle.default)(false);
  const updateFeature = () => {
    setIsUpdating(true);
    upsertQuery(feature.name, {
      description: featureDescription,
      filter: featureFilter
    }).finally(() => {
      setIsUpdating(false);
      refreshFeatures();
      closeFlyout();
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: closeFlyout,
    hideCloseButton: true,
    "aria-label": _i18n.i18n.translate('xpack.streams.featureDetails.flyoutAriaLabel', {
      defaultMessage: 'Feature details'
    }),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, feature.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.description', {
    defaultMessage: 'Description'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.markdownEditorAriaLabel', {
      defaultMessage: 'Feature description markdown editor'
    }),
    value: featureDescription,
    onChange: setFeatureDescription,
    height: 400,
    readOnly: false,
    initialViewMode: "viewing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.filter', {
    defaultMessage: 'Filter'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    onClick: toggleIsEditingCondition,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.filter.edit', {
      defaultMessage: 'Edit filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_shared.EditableConditionPanel, {
    condition: featureFilter,
    isEditingCondition: isEditingCondition,
    setCondition: setFeatureFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_feature_events_data.FeatureEventsData, {
    feature: feature,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isUpdating,
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "aria-label": _i18n.i18n.translate('xpack.streams.featureDetails.closeButtonAriaLabel', {
      defaultMessage: 'Close flyout'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.featureDetails.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isUpdating,
    onClick: updateFeature,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.featureDetails.saveChanges",
    defaultMessage: "Save changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }))))));
};
exports.StreamFeatureDetailsFlyout = StreamFeatureDetailsFlyout;