"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamExistingFeaturesTable = StreamExistingFeaturesTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../constants");
var _shared = require("../../shared");
var _use_streams_app_router = require("../../../../hooks/use_streams_app_router");
var _use_stream_features_api = require("../../../../hooks/use_stream_features_api");
var _stream_feature_details_flyout = require("./stream_feature_details_flyout");
var _feature_events_sparkline = require("./feature_events_sparkline");
var _table_title = require("./table_title");
var _use_ai_features = require("../../../stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/use_ai_features");
var _use_stream_features_table = require("./hooks/use_stream_features_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_features/stream_existing_features_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StreamExistingFeaturesTable({
  isLoading,
  features,
  definition,
  refreshFeatures
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const [selectedFeature, setSelectedFeature] = (0, _react.useState)();
  const [selectedFeatures, setSelectedFeatures] = (0, _react.useState)([]);
  const {
    removeFeaturesFromStream
  } = (0, _use_stream_features_api.useStreamFeaturesApi)(definition);
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const {
    descriptionColumn
  } = (0, _use_stream_features_table.useStreamFeaturesTable)();
  const goToGenerateSignificantEvents = significantEventsFeatures => {
    router.push('/{key}/management/{tab}', {
      path: {
        key: definition.name,
        tab: 'significantEvents'
      },
      query: {
        [_constants.OPEN_SIGNIFICANT_EVENTS_FLYOUT_URL_PARAM]: 'true',
        [_constants.SELECTED_FEATURES_URL_PARAM]: significantEventsFeatures.map(f => f.name).join(',')
      }
    });
  };
  const columns = [{
    field: 'name',
    name: TITLE_LABEL,
    width: '15%',
    sortable: true,
    truncateText: true
  }, descriptionColumn, {
    field: 'filter',
    name: FILTER_LABEL,
    width: '30%',
    render: filter => {
      return /*#__PURE__*/_react.default.createElement(_shared.ConditionPanel, {
        condition: filter,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 16
        }
      });
    }
  }, {
    name: EVENTS_LAST_24_HOURS_LABEL,
    width: '15%',
    render: feature => {
      return /*#__PURE__*/_react.default.createElement(_feature_events_sparkline.FeatureEventsSparkline, {
        feature: feature,
        definition: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 16
        }
      });
    }
  }, {
    name: ACTIONS_COLUMN_HEADER_LABEL,
    width: '5%',
    actions: [{
      name: GENERATE_SIGNIFICANT_EVENTS,
      description: GENERATE_SIGNIFICANT_EVENTS,
      type: 'icon',
      icon: 'crosshairs',
      enabled: () => aiFeatures !== null && aiFeatures !== void 0 && aiFeatures.genAiConnectors.selectedConnector ? true : false,
      onClick: feature => {
        goToGenerateSignificantEvents([feature]);
      }
    }, {
      name: EDIT_ACTION_NAME_LABEL,
      description: EDIT_ACTION_DESCRIPTION_LABEL,
      type: 'icon',
      icon: 'pencil',
      onClick: feature => {
        setSelectedFeature(feature);
      }
    }, {
      name: DELETE_ACTION_NAME_LABEL,
      description: DELETE_ACTION_DESCRIPTION_LABEL,
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: feature => {
        setIsDeleting(true);
        removeFeaturesFromStream([feature.name]).then(() => {
          refreshFeatures();
        }).finally(() => {
          setIsDeleting(false);
        });
      }
    }]
  }];
  const toggleDetails = feature => {
    setSelectedFeature(feature);
  };
  const columnsWithExpandingRowToggle = [{
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    }, OPEN_DETAILS_LABEL)),
    render: feature => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(feature),
        "aria-label": selectedFeature ? COLLAPSE_DETAILS_LABEL : EXPAND_DETAILS_LABEL,
        iconType: selectedFeature ? 'minimize' : 'expand',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 11
        }
      });
    }
  }, ...columns];
  const isGenerateSignificantEventsButtonDisabled = selectedFeatures.length === 0 || !(aiFeatures !== null && aiFeatures !== void 0 && aiFeatures.genAiConnectors.selectedConnector);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      padding: '16px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_table_title.TableTitle, {
    pageIndex: pageIndex,
    pageSize: pageSize,
    total: features.length,
    label: FEATURES_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      goToGenerateSignificantEvents(selectedFeatures);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: isGenerateSignificantEventsButtonDisabled,
    iconType: "crosshairs",
    size: "xs",
    "aria-label": GENERATE_SIGNIFICANT_EVENTS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, GENERATE_SIGNIFICANT_EVENTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    size: "xs",
    "aria-label": CLEAR_SELECTION,
    isDisabled: selectedFeatures.length === 0 || isLoading,
    onClick: () => {
      setSelectedFeatures([]);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, CLEAR_SELECTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isDeleting,
    size: "xs",
    iconType: "trash",
    color: "danger",
    "aria-label": DELETE_ALL,
    isDisabled: selectedFeatures.length === 0 || isLoading,
    onClick: () => {
      setIsDeleting(true);
      removeFeaturesFromStream(selectedFeatures.map(s => s.name)).then(() => {
        removeFeaturesFromStream(selectedFeatures.map(s => s.name)).finally(() => {
          setSelectedFeatures([]);
        });
      }).finally(() => {
        refreshFeatures();
        setIsDeleting(false);
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, DELETE_ALL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      height: 2
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoading,
    tableCaption: TABLE_CAPTION_LABEL,
    items: features,
    itemId: "name",
    columns: columnsWithExpandingRowToggle,
    noItemsMessage: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.noFeaturesMessage', {
      defaultMessage: 'No features found'
    }),
    selection: {
      initialSelected: selectedFeatures,
      onSelectionChange: setSelectedFeatures,
      selected: selectedFeatures
    },
    pagination: {
      pageSize,
      pageSizeOptions: [5, 10, 25],
      onChangePage: pIndex => {
        setPageIndex(pIndex);
      },
      onChangeItemsPerPage: pSize => {
        setPageSize(pSize);
        setPageIndex(0);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }), selectedFeature && /*#__PURE__*/_react.default.createElement(_stream_feature_details_flyout.StreamFeatureDetailsFlyout, {
    definition: definition,
    feature: selectedFeature,
    closeFlyout: () => {
      setSelectedFeature(undefined);
    },
    refreshFeatures: refreshFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  }));
}
const CLEAR_SELECTION = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.clearSelection', {
  defaultMessage: 'Clear selection'
});
const DELETE_ALL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.deleteSelection', {
  defaultMessage: 'Delete selected'
});
const GENERATE_SIGNIFICANT_EVENTS = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.generate', {
  defaultMessage: 'Generate significant events'
});

// i18n labels moved to end of file
const TITLE_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.title', {
  defaultMessage: 'Title'
});
const FILTER_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.filter', {
  defaultMessage: 'Filter'
});
const EVENTS_LAST_24_HOURS_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.eventsLast24Hours', {
  defaultMessage: 'Events (last 24 hours)'
});
const ACTIONS_COLUMN_HEADER_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actionsColumnHeader', {
  defaultMessage: 'Actions'
});
const EDIT_ACTION_NAME_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.editActionName', {
  defaultMessage: 'Edit'
});
const EDIT_ACTION_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.editActionDescription', {
  defaultMessage: 'Edit this feature'
});
const DELETE_ACTION_NAME_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.deleteActionName', {
  defaultMessage: 'Delete'
});
const DELETE_ACTION_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.deleteActionDescription', {
  defaultMessage: 'Delete this feature'
});
const OPEN_DETAILS_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.openDetails', {
  defaultMessage: 'Open details'
});
const COLLAPSE_DETAILS_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.collapseDetails', {
  defaultMessage: 'Collapse details'
});
const EXPAND_DETAILS_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.expandDetails', {
  defaultMessage: 'Expand details'
});
const FEATURES_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.tableTitle', {
  defaultMessage: 'Features'
});
const TABLE_CAPTION_LABEL = _i18n.i18n.translate('xpack.streams.streamFeaturesTable.tableCaption', {
  defaultMessage: 'List of features'
});