"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailureStoreInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _retention_card = require("./cards/retention_card");
var _storage_size_card = require("./cards/storage_size_card");
var _ingestion_card = require("./cards/ingestion_card");
var _ingestion_rate = require("./ingestion_rate");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/failure_store/failure_store_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FailureStoreInfo = ({
  openModal,
  definition,
  statsError,
  isLoadingStats,
  stats,
  config,
  timeState,
  aggregations
}) => {
  var _definition$privilege, _definition$privilege2, _definition$privilege3;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.title', {
    defaultMessage: 'Failure store '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.tooltip', {
      defaultMessage: 'A failure store is a secondary set of indices inside a data stream, dedicated to storing failed documents.'
    }),
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_retention_card.RetentionCard, {
    openModal: openModal,
    canManageFailureStore: (_definition$privilege = definition.privileges) === null || _definition$privilege === void 0 ? void 0 : _definition$privilege.manage_failure_store,
    isWired: _streamsSchema.Streams.WiredStream.GetResponse.is(definition),
    streamName: definition.stream.name,
    failureStore: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_storage_size_card.StorageSizeCard, {
    stats: stats,
    hasPrivileges: (_definition$privilege2 = definition.privileges) === null || _definition$privilege2 === void 0 ? void 0 : _definition$privilege2.manage_failure_store,
    statsError: statsError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    stats: stats,
    hasPrivileges: (_definition$privilege3 = definition.privileges) === null || _definition$privilege3 === void 0 ? void 0 : _definition$privilege3.manage_failure_store,
    statsError: statsError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_ingestion_rate.FailureStoreIngestionRate, {
    definition: definition,
    isLoadingStats: isLoadingStats,
    stats: stats,
    timeState: timeState,
    statsError: statsError,
    aggregations: aggregations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};
exports.FailureStoreInfo = FailureStoreInfo;