"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageSizeCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _insufficient_privileges = require("../../../../insufficient_privileges/insufficient_privileges");
var _base_metric_card = require("../../common/base_metric_card");
var _format_bytes = require("../../helpers/format_bytes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/failure_store/cards/storage_size_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StorageSizeCard = ({
  hasPrivileges,
  stats,
  statsError
}) => {
  const title = _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureStorageCard.title', {
    defaultMessage: 'Failure storage size'
  });
  const metric = [{
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: hasPrivileges,
      title: _i18n.i18n.translate('xpack.streams.storageSizeCard.privilegesWarningIconWrapper.storagesizeLabel', {
        defaultMessage: 'storageSize'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, statsError || !stats || stats.size === undefined ? '-' : (0, _format_bytes.formatBytes)(stats.size)),
    subtitle: hasPrivileges ? _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureStorageCard.documents', {
      defaultMessage: '{docsCount} documents',
      values: {
        docsCount: statsError || !stats || stats.count === undefined ? '-' : (0, _eui.formatNumber)(stats.count, '0,0')
      }
    }) : null,
    'data-test-subj': 'failureStoreStorageSize'
  }];
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    metrics: metric,
    "data-test-subj": "failureStoreStorageSize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 10
    }
  });
};
exports.StorageSizeCard = StorageSizeCard;