"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NestedChildrenProcessingSummary = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/where/nested_children_processing_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const statusLabels = {
  pending: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.pending', {
    defaultMessage: 'pending'
  }),
  running: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.running', {
    defaultMessage: 'running'
  }),
  failed: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.failed', {
    defaultMessage: 'failed'
  }),
  successful: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.successful', {
    defaultMessage: 'successful'
  }),
  disabled: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.disabled', {
    defaultMessage: 'disabled'
  }),
  skipped: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.skipped', {
    defaultMessage: 'skipped'
  })
};
const NestedChildrenProcessingSummary = ({
  childIds,
  stepsProcessingSummaryMap
}) => {
  if (!stepsProcessingSummaryMap) return null;
  const statusCounts = {};
  for (const id of childIds) {
    const status = stepsProcessingSummaryMap.get(id);
    if (status) {
      if (status === 'disabled.processorBeforePersisted') {
        statusCounts.disabled = (statusCounts.disabled || 0) + 1;
      } else if (status === 'skipped.followsProcessorBeingEdited' || status === 'skipped.createdInPreviousSimulation') {
        statusCounts.skipped = (statusCounts.skipped || 0) + 1;
      } else {
        statusCounts[status] = (statusCounts[status] || 0) + 1;
      }
    }
  }
  const total = Array.from(childIds).length;
  const summary = Object.entries(statusCounts).map(([status, count]) => `${count} ${statusLabels[status] || status}`).join(', ');
  const stepsLabel = _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.stepsLabel', {
    defaultMessage: '{count, plural, one {step} other {steps}}',
    values: {
      count: total
    }
  });
  return summary ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, summary, " ", stepsLabel) : null;
};
exports.NestedChildrenProcessingSummary = NestedChildrenProcessingSummary;