"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorTypeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _streamsSchema = require("@kbn/streams-schema");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _utils = require("../../../utils");
var _config_driven = require("./config_driven");
var _stream_enrichment_state_machine = require("../../../state_management/stream_enrichment_state_machine");
var _selectors = require("../../../state_management/simulation_state_machine/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/processor_type_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProcessorTypeSelector = ({
  disabled = false
}) => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const getEnrichmentState = (0, _stream_enrichment_state_machine.useGetStreamEnrichmentState)();
  const {
    reset
  } = (0, _reactHookForm.useFormContext)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'action',
    rules: {
      required: true
    }
  });
  const processorType = (0, _reactHookForm.useWatch)({
    name: 'action'
  });
  const isWired = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => _streamsSchema.Streams.WiredStream.GetResponse.is(snapshot.context.definition));
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.grokCollection);
  const handleChange = type => {
    const formState = (0, _utils.getDefaultFormStateByType)(type, (0, _selectors.selectPreviewRecords)(getEnrichmentState().context.simulatorRef.getSnapshot().context), {
      grokCollection
    });
    reset(formState);
  };
  const selectorOptions = _react.default.useMemo(() => getProcessorTypeSelectorOptions(isWired), [isWired]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorLabel', {
      defaultMessage: 'Processor'
    }),
    helpText: getProcessorDescription(core.docLinks, isWired)(processorType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "streamsAppProcessorTypeSelector",
    disabled: disabled,
    options: selectorOptions,
    isInvalid: fieldState.invalid,
    valueOfSelected: field.value,
    onChange: handleChange,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorPlaceholder', {
      defaultMessage: 'Grok, Dissect ...'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.ProcessorTypeSelector = ProcessorTypeSelector;
const getAvailableProcessors = isWired => ({
  date: {
    type: 'date',
    inputDisplay: 'Date',
    getDocUrl: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateHelpText",
      defaultMessage: "Converts a date to a document timestamp.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    })
  },
  dissect: {
    type: 'dissect',
    inputDisplay: 'Dissect',
    getDocUrl: docLinks => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectHelpText",
      defaultMessage: "Uses {dissectLink} patterns to extract matches from a field.",
      values: {
        dissectLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsDissectLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.dissect,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 109,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.dissectLinkLabel', {
          defaultMessage: 'dissect'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    })
  },
  grok: {
    type: 'grok',
    inputDisplay: 'Grok',
    getDocUrl: docLinks => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.grokHelpText",
      defaultMessage: "Uses {grokLink} expressions to extract matches from a field.",
      values: {
        grokLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsGrokLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.grok,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.grokLinkLabel', {
          defaultMessage: 'grok'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    })
  },
  set: {
    type: 'set',
    inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setInputDisplay', {
      defaultMessage: 'Set'
    }),
    getDocUrl: docLinks => {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setHelpText",
        defaultMessage: "{setLink} If the field already exists, its value will be replaced with the provided one.",
        values: {
          setLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "streamsAppAvailableProcessorsSetLink",
            external: true,
            target: "_blank",
            href: docLinks.links.ingest.set,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 163,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.streams.availableProcessors.setLinkLabel', {
            defaultMessage: 'Sets one field and associates it with the specified value.'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 9
        }
      });
    }
  },
  ..._config_driven.configDrivenProcessors,
  ...(isWired ? {} : {
    manual_ingest_pipeline: {
      type: 'manual_ingest_pipeline',
      inputDisplay: 'Manual pipeline configuration',
      getDocUrl: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.manualIngestPipelineHelpText",
        defaultMessage: "Specify an array of ingest pipeline processors using JSON.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 13
        }
      })
    }
  })
});
const getProcessorDescription = (docLinks, isWired) => type => {
  var _getAvailableProcesso;
  return (_getAvailableProcesso = getAvailableProcessors(isWired)[type]) === null || _getAvailableProcesso === void 0 ? void 0 : _getAvailableProcesso.getDocUrl(docLinks);
};
const getProcessorTypeSelectorOptions = isWired => Object.values(getAvailableProcessors(isWired)).map(({
  type,
  inputDisplay
}) => ({
  value: type,
  inputDisplay
}));