"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBlockEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _react2 = require("@xstate5/react");
var _use_discard_confirm = require("../../../../../../hooks/use_discard_confirm");
var _selectors = require("../../../state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("../../../state_management/stream_enrichment_state_machine");
var _utils = require("../../../utils");
var _fields = require("./config_driven/components/fields");
var _date = require("./date");
var _dissect = require("./dissect");
var _grok = require("./grok");
var _manual_ingest_pipeline = require("./manual_ingest_pipeline");
var _processor_metrics = require("./processor_metrics");
var _processor_type_selector = require("./processor_type_selector");
var _set = require("./set");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _prompt_options = require("./prompt_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionBlockEditor = exports.ActionBlockEditor = /*#__PURE__*/(0, _react.forwardRef)((props, ref) => {
  const {
    processorMetrics,
    stepRef
  } = props;
  const {
    appParams,
    core
  } = (0, _use_kibana.useKibana)();
  const getEnrichmentState = (0, _stream_enrichment_state_machine.useGetStreamEnrichmentState)();
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.context.grokCollection);
  const step = (0, _react2.useSelector)(stepRef, snapshot => snapshot.context.step);
  const [defaultValues] = (0, _react.useState)(() => (0, _utils.getFormStateFromActionStep)((0, _selectors.selectPreviewRecords)(getEnrichmentState().context.simulatorRef.getSnapshot().context), {
    grokCollection
  }, step));
  const methods = (0, _reactHookForm.useForm)({
    // TODO: See if this can be stricter, DeepPartial<ProcessorFormState> doesn't work
    defaultValues: defaultValues,
    mode: 'onChange'
  });
  (0, _react.useEffect)(() => {
    const {
      unsubscribe
    } = methods.watch(value => {
      const {
        processorDefinition,
        processorResources
      } = (0, _utils.convertFormStateToProcessor)(value);
      stepRef.send({
        type: 'step.changeProcessor',
        step: processorDefinition,
        resources: processorResources
      });
    });
    return () => unsubscribe();
  }, [methods, stepRef]);
  const isConfigured = (0, _react2.useSelector)(stepRef, snapshot => snapshot.matches('configured'));
  const canDelete = (0, _react2.useSelector)(stepRef, snapshot => snapshot.can({
    type: 'step.delete'
  }));
  const canSave = (0, _react2.useSelector)(stepRef, snapshot => snapshot.can({
    type: 'step.save'
  }));
  const hasStreamChanges = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.can({
    type: 'stream.reset'
  }));
  const hasStepChanges = (0, _react2.useSelector)(stepRef, snapshot => !(0, _lodash.isEqual)(snapshot.context.previousStep, snapshot.context.step));
  const type = (0, _reactHookForm.useWatch)({
    control: methods.control,
    name: 'action'
  });
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: hasStreamChanges || hasStepChanges,
    history: appParams.history,
    http: core.http,
    navigateToUrl: core.application.navigateToUrl,
    openConfirm: core.overlays.openConfirm,
    shouldPromptOnReplace: false
  });
  const handleCancel = (0, _use_discard_confirm.useDiscardConfirm)(() => stepRef.send({
    type: 'step.cancel'
  }), {
    enabled: hasStepChanges,
    ..._prompt_options.discardChangesPromptOptions
  });
  const handleDelete = (0, _use_discard_confirm.useDiscardConfirm)(() => stepRef.send({
    type: 'step.delete'
  }), {
    enabled: canDelete,
    ..._prompt_options.deleteProcessorPromptOptions
  });
  const handleSubmit = () => {
    stepRef.send({
      type: 'step.save'
    });
  };
  if (!(0, _streamlang.isActionBlock)(step)) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }, step.action.toUpperCase())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppProcessorConfigurationCancelButton",
    onClick: handleCancel,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ProcessorConfiguration.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppProcessorConfigurationSaveProcessorButton",
    size: "s",
    fill: true,
    onClick: methods.handleSubmit(handleSubmit),
    disabled: !canSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 19
    }
  }, isConfigured ? _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ProcessorConfiguration.confirmProcessor', {
    defaultMessage: 'Update'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ProcessorConfiguration.confirmCreateProcessor', {
    defaultMessage: 'Create'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, methods, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: methods.handleSubmit(handleSubmit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_processor_type_selector.ProcessorTypeSelector, {
    disabled: isConfigured,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }), type === 'date' && /*#__PURE__*/_react.default.createElement(_date.DateProcessorForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 35
    }
  }), type === 'grok' && /*#__PURE__*/_react.default.createElement(_grok.GrokProcessorForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 35
    }
  }), type === 'dissect' && /*#__PURE__*/_react.default.createElement(_dissect.DissectProcessorForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 38
    }
  }), type === 'manual_ingest_pipeline' && /*#__PURE__*/_react.default.createElement(_manual_ingest_pipeline.ManualIngestPipelineProcessorForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 53
    }
  }), type === 'set' && /*#__PURE__*/_react.default.createElement(_set.SetProcessorForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 34
    }
  }), !_utils.SPECIALISED_TYPES.includes(type) && /*#__PURE__*/_react.default.createElement(_fields.ConfigDrivenProcessorFields, {
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  })), canDelete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppProcessorConfigurationButton",
    color: "danger",
    onClick: handleDelete,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.deleteProcessorLabel', {
    defaultMessage: 'Delete processor'
  }))))), processorMetrics && !(0, _lodash.isEmpty)(processorMetrics.errors) && /*#__PURE__*/_react.default.createElement(_processor_metrics.ProcessorErrors, {
    metrics: processorMetrics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 15
    }
  })))));
});