"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DissectPatternDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/dissect/dissect_pattern_definition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DissectPatternDefinition = () => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const esDocUrl = core.docLinks.links.ingest.dissectKeyModifiers;
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'pattern',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternRequiredError', {
        defaultMessage: 'A pattern is required.'
      })
    }
  });
  const {
    invalid,
    error
  } = fieldState;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsLabel', {
      defaultMessage: 'Pattern'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsHelpText",
      defaultMessage: "Pattern used to dissect the specified field. The pattern is defined by the parts of the string to discard. Use a {keyModifier} to alter the dissection behavior.",
      values: {
        keyModifier: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppDissectPatternDefinitionKeyModifierLink",
          target: "_blank",
          external: true,
          href: esDocUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsLink', {
          defaultMessage: 'key modifier'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }),
    isInvalid: invalid,
    error: error === null || error === void 0 ? void 0 : error.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: serialize(field.value),
    onChange: value => field.onChange(deserialize(value)),
    languageId: "text",
    height: 75,
    options: {
      automaticLayout: true,
      minimap: {
        enabled: false
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsAriaLabel', {
      defaultMessage: 'Pattern editor'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
};
exports.DissectPatternDefinition = DissectPatternDefinition;
const serialize = input => {
  if (typeof input === 'string') {
    const s = JSON.stringify(input);
    return s.slice(1, s.length - 1);
  }
  return input;
};
const deserialize = input => {
  if (typeof input === 'string') {
    try {
      return JSON.parse(`"${input}"`);
    } catch (e) {
      return input;
    }
  }
};