"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isStepUnderEdit = exports.isRootStep = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStepUnderEdit = stepSnapshot => {
  return stepSnapshot.matches('draft') || stepSnapshot.matches({
    configured: 'editing'
  });
};
exports.isStepUnderEdit = isStepUnderEdit;
const isRootStep = stepSnapshot => {
  return stepSnapshot.context.step.parentId === null;
};
exports.isRootStep = isRootStep;