"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeXJson = exports.parseXJsonOrString = exports.deserializeJson = void 0;
var _public = require("@kbn/es-ui-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serializeXJson = (v, defaultVal = '{}') => {
  if (!v) {
    return defaultVal;
  }
  if (typeof v === 'string') {
    try {
      const obj = JSON.parse(_public.XJson.collapseLiteralStrings(v));
      return _public.XJson.expandLiteralStrings(JSON.stringify(obj, null, 2));
    } catch {
      return formatXJsonString(v);
    }
  }
  return _public.XJson.expandLiteralStrings(JSON.stringify(v, null, 2));
};
exports.serializeXJson = serializeXJson;
const deserializeJson = input => {
  try {
    return JSON.parse(input);
  } catch (e) {
    return input;
  }
};
exports.deserializeJson = deserializeJson;
const parseXJsonOrString = input => {
  try {
    return JSON.parse(_public.XJson.collapseLiteralStrings(input));
  } catch {
    return input;
  }
};

/**
 * Format a XJson string input as parsed JSON. Replaces the invalid characters
 *  with a placeholder, parses the new string in a JSON format with the expected
 * indentantion and then replaces the placeholders with the original values.
 */
exports.parseXJsonOrString = parseXJsonOrString;
const formatXJsonString = input => {
  let placeholder = 'PLACEHOLDER';
  const INVALID_STRING_REGEX = /"""(.*?)"""/gs;
  while (input.includes(placeholder)) {
    placeholder += '_';
  }
  const modifiedInput = input.replace(INVALID_STRING_REGEX, () => `"${placeholder}"`);
  let jsonObject;
  try {
    jsonObject = JSON.parse(modifiedInput);
  } catch (error) {
    return input;
  }
  let formattedJsonString = JSON.stringify(jsonObject, null, 2);
  const invalidStrings = input.match(INVALID_STRING_REGEX);
  if (invalidStrings) {
    invalidStrings.forEach(invalidString => {
      formattedJsonString = formattedJsonString.replace(`"${placeholder}"`, invalidString);
    });
  }
  return formattedJsonString;
};