"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectedFieldsEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
var _asset_image = require("../../asset_image");
var _schema_editor = require("../schema_editor");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _schema_editor_table = require("../schema_editor/schema_editor_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/detected_fields_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DetectedFieldsEditor = ({
  detectedFields
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    mapField,
    unmapField
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const definition = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition);
  const isWiredStream = _streamsSchema.Streams.WiredStream.GetResponse.is(definition);
  const [selectedFields, setSelectedFields] = _react.default.useState(detectedFields.filter(field => (0, _schema_editor_table.isSelectableField)(definition.stream.name, field)).map(({
    name
  }) => name));
  const hasFields = detectedFields.length > 0;
  if (!hasFields) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      titleSize: "xs",
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 15
        }
      }),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFields.noResults.content', {
        defaultMessage: 'No fields were detected. Add fields manually from the Schema tab.'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isWiredStream && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    color: "subdued",
    size: "xs",
    css: (0, _react2.css)`
            margin-bottom: ${euiTheme.size.base};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFieldsHeadline', {
    defaultMessage: 'You can review and adjust saved fields further in the Schema tab.'
  })), /*#__PURE__*/_react.default.createElement(_schema_editor.SchemaEditor, {
    defaultColumns: ['name', 'type', 'format', 'status', 'source'],
    fields: detectedFields,
    stream: definition.stream,
    onFieldUpdate: field => {
      if (field.status === 'mapped') {
        mapField(field);
      } else if (field.status === 'unmapped') {
        unmapField(field.name);
      }
    },
    onFieldSelection: (names, checked) => {
      setSelectedFields(selection => {
        if (checked) {
          return (0, _lodash.uniq)([...selection, ...names]);
        } else {
          return selection.filter(name => !names.includes(name));
        }
      });
    },
    fieldSelection: selectedFields,
    withControls: true,
    withTableActions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};
exports.DetectedFieldsEditor = DetectedFieldsEditor;