"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChildrenAffectedCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_streams_app_router = require("../../../../hooks/use_streams_app_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/children_affected_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ChildrenAffectedCallout = ({
  childStreams
}) => {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const childStreamLinks = childStreams.map(stream => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "streamsAppChildStreamLinksLink",
      href: router.link('/{key}', {
        path: {
          key: stream.destination
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 7
      }
    }, stream.destination);
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('xpack.streams.childStreamsWarning.title', {
      defaultMessage: 'Field changes'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.childStreamsWarning.text",
    defaultMessage: "Editing this field will affect it's dependant streams: {affectedStreams}",
    values: {
      affectedStreams: childStreamLinks.map((link, i) => [i > 0 && ', ', link])
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }));
};
exports.ChildrenAffectedCallout = ChildrenAffectedCallout;