"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementBottomBar = ManagementBottomBar;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_discard_confirm = require("../../../hooks/use_discard_confirm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/management_bottom_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ManagementBottomBar({
  confirmButtonText = defaultConfirmButtonText,
  disabled = false,
  isLoading = false,
  insufficientPrivileges = false,
  isInvalid = false,
  onCancel,
  onConfirm
}) {
  const handleCancel = (0, _use_discard_confirm.useDiscardConfirm)(onCancel, {
    title: discardUnsavedChangesTitle,
    message: discardUnsavedChangesMessage,
    confirmButtonText: discardUnsavedChangesLabel,
    cancelButtonText: keepEditingLabel
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    position: "sticky",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppManagementBottomBarCancelChangesButton",
    disabled: disabled,
    color: "text",
    size: "s",
    iconType: "cross",
    onClick: handleCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.bottomBar.cancel', {
    defaultMessage: 'Cancel changes'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isInvalid ? _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.bottomBar.fixErrors', {
      defaultMessage: 'Please fix the errors before saving.'
    }) : insufficientPrivileges ? _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.bottomBar.onlySimulate', {
      defaultMessage: "You don't have sufficient privileges to save changes."
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppManagementBottomBarButton",
    disabled: disabled || insufficientPrivileges || isInvalid,
    color: "primary",
    fill: true,
    size: "s",
    iconType: "check",
    onClick: onConfirm,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, confirmButtonText))));
}
const defaultConfirmButtonText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.bottomBar.confirm', {
  defaultMessage: 'Save changes'
});
const discardUnsavedChangesLabel = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.discardUnsavedChangesLabel', {
  defaultMessage: 'Discard unsaved changes'
});
const keepEditingLabel = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.discardUnsavedChangesKeepEditing', {
  defaultMessage: 'Keep editing'
});
const discardUnsavedChangesTitle = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.discardUnsavedChangesTitle', {
  defaultMessage: 'Unsaved changes'
});
const discardUnsavedChangesMessage = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.discardUnsavedChangesMessage', {
  defaultMessage: 'You are about to leave this view without saving. All changes will be lost. Do you really want to leave without saving?'
});