"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsAppLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _common = require("@kbn/kibana-utils-plugin/common");
var _common2 = require("../url_schema/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StreamsAppLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _deeplinksObservability.STREAMS_APP_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      let path = '/';
      if (params.name) {
        // Concat stream name
        path = `/${params.name}`;

        // Concat management tab
        if (params.managementTab) {
          path = `/${params.name}/management/${params.managementTab}`;

          // Concat page state
          if (params.pageState) {
            path = (0, _common.setStateToKbnUrl)(_common2.ENRICHMENT_URL_STATE_KEY, params.pageState, {
              useHash: false,
              storeInHashQuery: false
            }, path);
          }
        }
      }
      return {
        app: 'streams',
        path,
        state: {}
      };
    });
  }
}
exports.StreamsAppLocatorDefinition = StreamsAppLocatorDefinition;