"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionStream = partitionStream;
var _inferencePromptUtils = require("@kbn/inference-prompt-utils");
var _lodash = require("lodash");
var _streamlang = require("@kbn/streamlang");
var _zodHelpers = require("@kbn/zod-helpers");
var _cluster_logs = require("../../src/cluster_logs/cluster_logs");
var _prompt = require("./prompt");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strictConditionSchema = (0, _zodHelpers.DeepStrict)(_streamlang.conditionSchema);
async function partitionStream({
  definition,
  inferenceClient,
  esClient,
  logger,
  start,
  end,
  maxSteps,
  signal
}) {
  var _response$toolCalls$f, _response$toolCalls;
  const initialClusters = await (0, _cluster_logs.clusterLogs)({
    esClient,
    start,
    end,
    index: definition.name,
    logger,
    partitions: [],
    size: 1000
  });

  // No need to involve reasoning if there are no initial clusters
  if (initialClusters.length === 0) {
    return [];
  }

  // No need to involve reasoning if there are no sample documents
  if (initialClusters.every(cluster => cluster.clustering.sampled === 0)) {
    return [];
  }
  const response = await (0, _inferencePromptUtils.executeAsReasoningAgent)({
    inferenceClient,
    prompt: _prompt.SuggestStreamPartitionsPrompt,
    input: {
      stream: definition,
      initial_clustering: JSON.stringify(initialClusters),
      condition_schema: JSON.stringify(_schema.schema)
    },
    maxSteps,
    toolCallbacks: {
      partition_logs: async toolCall => {
        var _toolCall$function$ar;
        const partitions = (_toolCall$function$ar = toolCall.function.arguments.partitions) !== null && _toolCall$function$ar !== void 0 ? _toolCall$function$ar : [];
        const partitionsResponse = await (0, _cluster_logs.clusterLogs)({
          esClient,
          start,
          end,
          index: toolCall.function.arguments.index,
          partitions,
          logger
        });
        return {
          response: {
            partitions: partitionsResponse
          }
        };
      }
    },
    finalToolChoice: {
      type: 'function',
      function: 'partition_logs'
    },
    abortSignal: signal
  });
  const proposedPartitions = (_response$toolCalls$f = response === null || response === void 0 ? void 0 : (_response$toolCalls = response.toolCalls) === null || _response$toolCalls === void 0 ? void 0 : _response$toolCalls.flatMap(toolCall => {
    var _toolCall$function$ar2;
    return (_toolCall$function$ar2 = toolCall.function.arguments.partitions) !== null && _toolCall$function$ar2 !== void 0 ? _toolCall$function$ar2 : [];
  }).map(({
    name,
    condition
  }) => {
    // Sanitize name to be alphanumeric with dashes only, lowercase
    const sanitizedName = name.toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');
    return {
      name: `${definition.name}.${sanitizedName}`,
      condition: condition
    };
  })) !== null && _response$toolCalls$f !== void 0 ? _response$toolCalls$f : [];
  return proposedPartitions.filter(({
    condition
  }) => strictConditionSchema.safeParse(condition).success && !(0, _lodash.isEqual)(condition, {
    always: {}
  }));
}