"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateStreamDescriptionPrompt = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _zod = require("@kbn/zod");
var _system_prompt = _interopRequireDefault(require("./system_prompt.text"));
var _user_prompt = _interopRequireDefault(require("./user_prompt.text"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateStreamDescriptionPrompt = exports.GenerateStreamDescriptionPrompt = (0, _inferenceCommon.createPrompt)({
  name: 'generate_stream_description',
  input: _zod.z.object({
    name: _zod.z.string(),
    dataset_analysis: _zod.z.string()
  })
}).version({
  system: {
    mustache: {
      template: _system_prompt.default
    }
  },
  template: {
    mustache: {
      template: _user_prompt.default
    }
  }
}).get();