"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dissectKeyRightModifiers = exports.dissectKeyModifiers = exports.dissectKeyLeftModifiers = exports.dissectGrokESQLDataTypes = void 0;
exports.isDissectKeyLeftModifier = isDissectKeyLeftModifier;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dissectKeyLeftModifiers = exports.dissectKeyLeftModifiers = ['+',
// Append
'?',
// Named skip key
'*',
// Reference key (ingest)
'&' // Dereference key (ingest)
];
const dissectKeyRightModifiers = exports.dissectKeyRightModifiers = ['->' // Skip right padding
];
const dissectKeyModifiers = exports.dissectKeyModifiers = [...dissectKeyLeftModifiers, ...dissectKeyRightModifiers];

/**
 * A type representing a single-character left-side modifier.
 */

function isDissectKeyLeftModifier(char) {
  return dissectKeyLeftModifiers.includes(char);
}

/**
 * A type representing the supported dissect key modifiers.
 * Includes generic '/n' order specification for append ordering.
 */

/**
 * Common data types supported by both DISSECT and GROK
 */
const dissectGrokESQLDataTypes = exports.dissectGrokESQLDataTypes = ['keyword', 'int', 'long', 'float'];

/**
 * A type representing the common data types
 */

/**
 * Interface representing a field extracted from a pattern (DISSECT or GROK)
 */

/**
 * Result of parsing multiple patterns, with fields grouped by pattern
 */