"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processManualIngestPipelineProcessors = void 0;
var _manual_ingest_pipeline_processors = require("../../../../types/processors/manual_ingest_pipeline_processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processManualIngestPipelineProcessors = (manualIngestPipelineProcessor, transpilationOptions) => {
  // manual_ingest_pipeline processor is a special case, since it has nested Elasticsearch-level processors and doesn't support if
  // directly - we need to add it to each nested processor
  return manualIngestPipelineProcessor.processors.flatMap(nestedProcessor => {
    var _manualIngestPipeline, _nestedConfig$ignore_;
    const nestedType = Object.keys(nestedProcessor)[0];
    if (!_manual_ingest_pipeline_processors.elasticsearchProcessorTypes.includes(nestedType)) {
      if (transpilationOptions !== null && transpilationOptions !== void 0 && transpilationOptions.ignoreMalformed) {
        return [];
      }
      throw new Error(`Invalid processor type "${nestedType}" in manual_ingest_pipeline processor. Supported types: ${_manual_ingest_pipeline_processors.elasticsearchProcessorTypes.join(', ')}`);
    }
    const nestedConfig = nestedProcessor[nestedType];
    if (typeof nestedConfig !== 'object' || nestedConfig === null) {
      if (transpilationOptions !== null && transpilationOptions !== void 0 && transpilationOptions.ignoreMalformed) {
        return [];
      }
      throw new Error(`Invalid processor config for "${nestedType}" in manual_ingest_pipeline processor. Expected an object.`);
    }
    return {
      [nestedType]: {
        ...nestedConfig,
        tag: (_manualIngestPipeline = manualIngestPipelineProcessor.tag) !== null && _manualIngestPipeline !== void 0 ? _manualIngestPipeline : nestedConfig.tag,
        ignore_failure: (_nestedConfig$ignore_ = nestedConfig.ignore_failure) !== null && _nestedConfig$ignore_ !== void 0 ? _nestedConfig$ignore_ : manualIngestPipelineProcessor.ignore_failure,
        on_failure: nestedConfig.on_failure ? [...nestedConfig.on_failure, ...(manualIngestPipelineProcessor.on_failure || [])] : manualIngestPipelineProcessor.on_failure,
        ...(!nestedConfig.if && 'if' in manualIngestPipelineProcessor && manualIngestPipelineProcessor.if ? {
          if: manualIngestPipelineProcessor.if
        } : {})
      }
    };
  });
};
exports.processManualIngestPipelineProcessors = processManualIngestPipelineProcessors;