"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transpile = exports.conditionToESQL = void 0;
var _function = require("fp-ts/function");
var _streamlang = require("../../../types/streamlang");
var _flatten_steps = require("../shared/flatten_steps");
var _conversions = require("./conversions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PIPE_TAB = '  ';
const conditionToESQL = condition => {
  return (0, _conversions.convertConditionToESQL)(condition);
};
exports.conditionToESQL = conditionToESQL;
const transpile = (streamlang, transpilationOptions = {
  pipeTab: DEFAULT_PIPE_TAB
}) => {
  const validatedStreamlang = _streamlang.streamlangDSLSchema.parse(streamlang);
  const esqlCommandsFromStreamlang = (0, _function.pipe)((0, _flatten_steps.flattenSteps)(validatedStreamlang.steps), steps => (0, _conversions.convertStreamlangDSLToESQLCommands)(steps, transpilationOptions));
  const commandsArray = [esqlCommandsFromStreamlang].filter(Boolean);
  return {
    query: `  | ${commandsArray.join('\n|')}`,
    commands: commandsArray
  };
};
exports.transpile = transpile;