"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimlaneFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("../types");
var _helpers2 = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/swimlane/steps/swimlane_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const SINGLE_SELECTION = {
  asPlainText: true
};
const EMPTY_COMBO_BOX_ARRAY = [];
const formatOption = field => ({
  label: `${field.name} (${field.key})`,
  value: field.id
});
const createSelectedOption = field => field != null ? [formatOption(field)] : EMPTY_COMBO_BOX_ARRAY;
const connectorTypeButtons = [{
  id: _types.SwimlaneConnectorType.All,
  label: 'All'
}, {
  id: _types.SwimlaneConnectorType.Alerts,
  label: 'Alerts'
}, {
  id: _types.SwimlaneConnectorType.Cases,
  label: 'Cases'
}];
const mappingConfig = {
  defaultValue: null,
  validations: [{
    validator: ({
      value,
      customData
    }) => {
      const data = customData.value;
      if ((0, _helpers2.isRequiredField)(data.connectorType, value === null || value === void 0 ? void 0 : value.id)) {
        return {
          message: data.validationLabel
        };
      }
    }
  }]
};
const MappingField = /*#__PURE__*/_react.default.memo(({
  path,
  options,
  label,
  validationLabel,
  dataTestSubj,
  fieldIdMap,
  connectorType,
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    component: _components.ComboBoxField,
    config: mappingConfig,
    validationData: {
      connectorType,
      validationLabel
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, field => {
    var _field$value$id, _field$value;
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onComboChange = opt => {
      var _option$value;
      const option = opt[0];
      const item = fieldIdMap.get((_option$value = option === null || option === void 0 ? void 0 : option.value) !== null && _option$value !== void 0 ? _option$value : '');
      if (!item) {
        field.setValue(null);
        return;
      }
      field.setValue({
        id: item.id,
        name: item.name,
        key: item.key,
        fieldType: item.fieldType
      });
    };
    const onSearchComboChange = value => {
      if (value !== undefined) {
        field.clearErrors(_hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM);
      }
    };
    const selectedOptions = createSelectedOption(fieldIdMap.get((_field$value$id = (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.id) !== null && _field$value$id !== void 0 ? _field$value$id : ''));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      error: errorMessage,
      isInvalid: isInvalid,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      singleSelection: SINGLE_SELECTION,
      selectedOptions: selectedOptions,
      onChange: onComboChange,
      onSearchChange: onSearchComboChange,
      fullWidth: true,
      noSuggestions: false,
      "data-test-subj": dataTestSubj,
      options: options,
      isDisabled: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 15
      }
    }));
  });
});
const SwimlaneFieldsComponent = ({
  fields,
  readOnly
}) => {
  var _config$connectorType;
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.connectorType']
  });
  const connectorType = (_config$connectorType = config === null || config === void 0 ? void 0 : config.connectorType) !== null && _config$connectorType !== void 0 ? _config$connectorType : _types.SwimlaneConnectorType.All;
  const [fieldTypeMap, fieldIdMap] = (0, _react.useMemo)(() => fields.reduce(([typeMap, idMap], field) => {
    if (field != null) {
      var _typeMap$get;
      typeMap.set(field.fieldType, [...((_typeMap$get = typeMap.get(field.fieldType)) !== null && _typeMap$get !== void 0 ? _typeMap$get : []), formatOption(field)]);
      idMap.set(field.id, field);
    }
    return [typeMap, idMap];
  }, [new Map(), new Map()]), [fields]);
  const textOptions = (0, _react.useMemo)(() => {
    var _fieldTypeMap$get;
    return (_fieldTypeMap$get = fieldTypeMap.get('text')) !== null && _fieldTypeMap$get !== void 0 ? _fieldTypeMap$get : [];
  }, [fieldTypeMap]);
  const commentsOptions = (0, _react.useMemo)(() => {
    var _fieldTypeMap$get2;
    return (_fieldTypeMap$get2 = fieldTypeMap.get('comments')) !== null && _fieldTypeMap$get2 !== void 0 ? _fieldTypeMap$get2 : [];
  }, [fieldTypeMap]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.connectorType",
    component: _components.ButtonGroupField,
    config: {
      label: i18n.SW_CONNECTOR_TYPE_LABEL,
      defaultValue: _types.SwimlaneConnectorType.All,
      validations: [{
        validator: emptyField(i18n.SW_REQUIRED_CONNECTOR_TYPE)
      }]
    },
    componentProps: {
      euiFieldProps: {
        legend: i18n.SW_CONNECTOR_TYPE_LABEL,
        options: connectorTypeButtons,
        buttonSize: 'm',
        color: 'primary'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'alertIdConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.alertIdConfig",
    label: i18n.SW_ALERT_ID_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_ALERT_ID,
    options: textOptions,
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    dataTestSubj: "swimlaneAlertIdInput",
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'ruleNameConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.ruleNameConfig",
    label: i18n.SW_RULE_NAME_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_ALERT_ID,
    options: textOptions,
    dataTestSubj: "swimlaneAlertNameInput",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'severityConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.severityConfig",
    label: i18n.SW_SEVERITY_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_SEVERITY,
    options: textOptions,
    dataTestSubj: "swimlaneSeverityInput",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'caseIdConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.caseIdConfig",
    label: i18n.SW_CASE_ID_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_CASE_ID,
    options: textOptions,
    dataTestSubj: "swimlaneCaseIdConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'caseNameConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.caseNameConfig",
    label: i18n.SW_CASE_NAME_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_CASE_NAME,
    options: textOptions,
    dataTestSubj: "swimlaneCaseNameConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'commentsConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.commentsConfig",
    label: i18n.SW_COMMENTS_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_COMMENTS,
    options: commentsOptions,
    dataTestSubj: "swimlaneCommentsConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }), (0, _helpers2.isValidFieldForConnector)(connectorType, 'descriptionConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.descriptionConfig",
    label: i18n.SW_DESCRIPTION_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_DESCRIPTION,
    options: textOptions,
    dataTestSubj: "swimlaneDescriptionConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 9
    }
  }));
};
const SwimlaneFields = exports.SwimlaneFields = /*#__PURE__*/_react.default.memo(SwimlaneFieldsComponent);