"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../../common/auth/constants");
var _validator = require("../validator");
var _action_variables = require("../action_variables");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/cases_webhook/steps/get.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const GetStep = ({
  display,
  readOnly
}) => {
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.getIncidentMethod']
  });
  const {
    getIncidentMethod = _constants.WebhookMethods.GET
  } = config !== null && config !== void 0 ? config : {};
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "getStep",
    style: {
      display: display ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, i18n.STEP_3), /*#__PURE__*/_react.default.createElement("small", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, i18n.STEP_3_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentMethod",
    component: _components.Field,
    config: {
      label: i18n.GET_INCIDENT_METHOD,
      defaultValue: _constants.WebhookMethods.GET,
      type: _hook_form_lib.FIELD_TYPES.SELECT,
      validations: [{
        validator: emptyField(i18n.GET_METHOD_REQUIRED)
      }]
    },
    css: (0, _react2.css)`
                .euiFormRow__labelWrapper {
                  margin-bottom: 9px;
                }
              `,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookGetIncidentMethodSelect',
        options: [_constants.WebhookMethods.GET, _constants.WebhookMethods.POST].map(verb => ({
          text: verb.toUpperCase(),
          value: verb
        })),
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentUrl",
    config: {
      label: i18n.GET_INCIDENT_URL,
      validations: [{
        validator: urlField(i18n.GET_INCIDENT_URL_REQUIRED)
      }, {
        validator: (0, _validator.containsExternalIdForGet)(getIncidentMethod)
      }],
      helpText: i18n.GET_INCIDENT_URL_HELP
    },
    component: _public.MustacheTextFieldWrapper,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'webhookGetUrlText',
        messageVariables: _action_variables.urlVars,
        paramsProperty: 'getIncidentUrl',
        buttonTitle: i18n.ADD_CASES_VARIABLE,
        showButtonTitle: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))), getIncidentMethod === _constants.WebhookMethods.POST ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentJson",
    config: {
      helpText: i18n.GET_INCIDENT_JSON_HELP,
      label: i18n.GET_INCIDENT_JSON,
      validations: [{
        validator: (0, _validator.requiredJsonForPost)(getIncidentMethod)
      }]
    },
    component: _public.JsonFieldWrapper,
    componentProps: {
      euiCodeEditorProps: {
        height: '200px',
        isReadOnly: readOnly,
        ['aria-label']: i18n.CODE_EDITOR
      },
      dataTestSubj: 'webhookGetIncidentJson',
      messageVariables: _action_variables.urlVars,
      paramsProperty: 'getIncidentJson',
      buttonTitle: i18n.ADD_CASES_VARIABLE,
      showButtonTitle: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentResponseExternalTitleKey",
    config: {
      label: i18n.GET_INCIDENT_TITLE_KEY,
      validations: [{
        validator: emptyField(i18n.GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED)
      }],
      helpText: i18n.GET_INCIDENT_TITLE_KEY_HELP
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'getIncidentResponseExternalTitleKeyText'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.viewIncidentUrl",
    config: {
      label: i18n.EXTERNAL_INCIDENT_VIEW_URL,
      validations: [{
        validator: urlField(i18n.GET_INCIDENT_VIEW_URL_REQUIRED)
      }, {
        validator: (0, _validator.containsExternalIdOrTitle)()
      }],
      helpText: i18n.EXTERNAL_INCIDENT_VIEW_URL_HELP
    },
    component: _public.MustacheTextFieldWrapper,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'viewIncidentUrlText',
        messageVariables: _action_variables.urlVarsExt,
        paramsProperty: 'viewIncidentUrl',
        buttonTitle: i18n.ADD_CASES_VARIABLE,
        showButtonTitle: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }))));
};
exports.GetStep = GetStep;