"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bedrockSecrets = exports.bedrockConfig = exports.DEFAULT_BODY = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/bedrock/constants");
var _genai_connectors = require("../../common/genai_connectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/bedrock/constants.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const human = '\n\nHuman:';
const DEFAULT_BODY = exports.DEFAULT_BODY = JSON.stringify({
  anthropic_version: 'bedrock-2023-05-31',
  messages: [{
    content: 'Hello world',
    role: 'user'
  }],
  max_tokens: _constants.DEFAULT_TOKEN_LIMIT,
  stop_sequences: [human]
});
const bedrockConfig = exports.bedrockConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: _constants.DEFAULT_BEDROCK_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Amazon Bedrock API endpoint URL. For more information on the URL, refer to the {bedrockAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockDocumentation",
    values: {
      bedrockAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "bedrock-api-doc",
        href: "https://docs.aws.amazon.com/general/latest/gr/bedrock.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  })
}, {
  id: 'defaultModel',
  label: i18n.DEFAULT_MODEL_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current support is for the Anthropic Claude models. The model can be set on a per request basis by including a \"model\" parameter alongside the request body. If no model is provided, the fallback will be the default model -  Claude 3 Sonnet. For more information, refer to the {bedrockAPIModelDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockDocumentationModel",
    values: {
      bedrockAPIModelDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "bedrock-api-model-doc",
        href: "https://aws.amazon.com/bedrock/claude/",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }),
  defaultValue: _constants.DEFAULT_BEDROCK_MODEL
}, _genai_connectors.contextWindowLengthField];
const bedrockSecrets = exports.bedrockSecrets = [{
  id: 'accessKey',
  label: i18n.ACCESS_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The AWS access key for HTTP Basic authentication. For more details about generating AWS security credentials, refer to the {bedrockAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockApiKeyDocumentation",
    values: {
      bedrockAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "aws-api-keys-doc",
        href: "https://docs.aws.amazon.com/IAM/latest/UserGuide/security-creds.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 13
        }
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  })
}, {
  id: 'secret',
  label: i18n.SECRET,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The AWS secret for HTTP Basic authentication. For more details about generating AWS security credentials, refer to the {bedrockAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockSecretDocumentation",
    values: {
      bedrockAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "aws-api-keys-doc",
        href: "https://docs.aws.amazon.com/IAM/latest/UserGuide/security-creds.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  })
}];