"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfigService {
  static init({
    config
  }) {
    this.config = config;
  }
  static get() {
    if (!this.config) {
      this.throwUninitializedError();
    }
    return this.config;
  }
  static throwUninitializedError() {
    throw new Error('Config service not initialized - are you trying to import this module from outside of the stack connectors?');
  }
}
exports.ConfigService = ConfigService;
(0, _defineProperty2.default)(ConfigService, "config", void 0);