"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SSLCertFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("../../../common/auth/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/common/auth/ssl_cert_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const SSLCertFields = ({
  readOnly,
  certTypeDefaultValue,
  certType,
  isPfxEnabled = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  "data-test-subj": "sslCertFields",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.password",
  config: {
    label: i18n.PASSWORD
  },
  component: _components.PasswordField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLPassphraseInput',
      readOnly
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.certType",
  defaultValue: certTypeDefaultValue,
  component: ({
    field
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    "data-test-subj": "webhookCertTypeTabs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => field.setValue(_constants.SSLCertType.CRT),
    isSelected: field.value === _constants.SSLCertType.CRT || !isPfxEnabled,
    "data-test-subj": "webhookCertTypeCRTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, i18n.CERT_TYPE_CRT_KEY), isPfxEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => field.setValue(_constants.SSLCertType.PFX),
    isSelected: field.value === _constants.SSLCertType.PFX,
    "data-test-subj": "webhookCertTypePFXTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }, i18n.CERT_TYPE_PFX)),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 7
  }
}), (!isPfxEnabled || certType === _constants.SSLCertType.CRT) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: {
    minWidth: 200
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.crt",
  config: {
    label: 'CRT file',
    validations: [{
      validator: emptyField(i18n.CRT_REQUIRED)
    }]
  },
  component: _components.FilePickerField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLCRTInput',
      display: 'default',
      accept: '.crt,.cert,.cer,.pem'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 13
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: {
    minWidth: 200
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.key",
  config: {
    label: 'KEY file',
    validations: [{
      validator: emptyField(i18n.KEY_REQUIRED)
    }]
  },
  component: _components.FilePickerField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLKEYInput',
      display: 'default',
      accept: '.key,.pem'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 13
  }
}))), isPfxEnabled && certType === _constants.SSLCertType.PFX && /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.pfx",
  config: {
    label: 'PFX file',
    validations: [{
      validator: emptyField(i18n.PFX_REQUIRED)
    }]
  },
  component: _components.FilePickerField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLPFXInput',
      display: 'default',
      accept: '.pfx,.p12'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 9
  }
})));
exports.SSLCertFields = SSLCertFields;