"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestConnectorParamsSchema = exports.RunScriptParamsSchema = exports.ReleaseHostParamsSchema = exports.MicrosoftDefenderEndpointSecretsSchema = exports.MicrosoftDefenderEndpointEmptyParamsSchema = exports.MicrosoftDefenderEndpointDoNotValidateResponseSchema = exports.MicrosoftDefenderEndpointConfigSchema = exports.MicrosoftDefenderEndpointBaseApiResponseSchema = exports.MicrosoftDefenderEndpointActionParamsSchema = exports.MSDefenderLibraryFileSchema = exports.IsolateHostParamsSchema = exports.GetLibraryFilesResponse = exports.GetActionsParamsSchema = exports.GetActionResultsParamsSchema = exports.DownloadActionResultsResponseSchema = exports.CancelParamsSchema = exports.AgentListParamsSchema = exports.AgentDetailsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// ----------------------------------
// Connector setup schemas
// ----------------------------------
const MicrosoftDefenderEndpointConfigSchema = exports.MicrosoftDefenderEndpointConfigSchema = _configSchema.schema.object({
  clientId: _configSchema.schema.string({
    minLength: 1
  }),
  tenantId: _configSchema.schema.string({
    minLength: 1
  }),
  oAuthServerUrl: _configSchema.schema.string({
    minLength: 1
  }),
  oAuthScope: _configSchema.schema.string({
    minLength: 1
  }),
  apiUrl: _configSchema.schema.string({
    minLength: 1
  })
});
const MicrosoftDefenderEndpointSecretsSchema = exports.MicrosoftDefenderEndpointSecretsSchema = _configSchema.schema.object({
  clientSecret: _configSchema.schema.string({
    minLength: 1
  })
});

// ----------------------------------
// Connector Methods
// ----------------------------------
const MicrosoftDefenderEndpointDoNotValidateResponseSchema = exports.MicrosoftDefenderEndpointDoNotValidateResponseSchema = _configSchema.schema.any();
const MicrosoftDefenderEndpointBaseApiResponseSchema = exports.MicrosoftDefenderEndpointBaseApiResponseSchema = _configSchema.schema.maybe(_configSchema.schema.object({}, {
  unknowns: 'allow'
}));
const MicrosoftDefenderEndpointEmptyParamsSchema = exports.MicrosoftDefenderEndpointEmptyParamsSchema = _configSchema.schema.object({});
const TestConnectorParamsSchema = exports.TestConnectorParamsSchema = _configSchema.schema.object({});
const AgentDetailsParamsSchema = exports.AgentDetailsParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    minLength: 1
  })
});
const MachineHealthStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('Active'), _configSchema.schema.literal('Inactive'), _configSchema.schema.literal('ImpairedCommunication'), _configSchema.schema.literal('NoSensorData'), _configSchema.schema.literal('NoSensorDataImpairedCommunication'), _configSchema.schema.literal('Unknown')]);
const AgentListParamsSchema = exports.AgentListParamsSchema = _configSchema.schema.object({
  computerDnsName: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  version: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  deviceValue: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  aaDeviceId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  machineTags: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  lastSeen: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  exposureLevel: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  onboardingStatus: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  lastIpAddress: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  healthStatus: _configSchema.schema.maybe(_configSchema.schema.oneOf([MachineHealthStatusSchema, _configSchema.schema.arrayOf(MachineHealthStatusSchema, {
    minSize: 1
  })])),
  osPlatform: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  riskScore: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  rbacGroupId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  page: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    defaultValue: 1
  })),
  pageSize: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    max: 1000,
    defaultValue: 20
  }))
});
const IsolateHostParamsSchema = exports.IsolateHostParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    minLength: 1
  }),
  comment: _configSchema.schema.string({
    minLength: 1
  })
});
const ReleaseHostParamsSchema = exports.ReleaseHostParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    minLength: 1
  }),
  comment: _configSchema.schema.string({
    minLength: 1
  })
});
const RunScriptParamsSchema = exports.RunScriptParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    minLength: 1
  }),
  comment: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  parameters: _configSchema.schema.object({
    scriptName: _configSchema.schema.string({
      minLength: 1
    }),
    args: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    }))
  })
});
const CancelParamsSchema = exports.CancelParamsSchema = _configSchema.schema.object({
  comment: _configSchema.schema.string({
    minLength: 1
  }),
  actionId: _configSchema.schema.string({
    minLength: 1
  })
});
const MachineActionTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('RunAntiVirusScan'), _configSchema.schema.literal('Offboard'), _configSchema.schema.literal('LiveResponse'), _configSchema.schema.literal('CollectInvestigationPackage'), _configSchema.schema.literal('Isolate'), _configSchema.schema.literal('Unisolate'), _configSchema.schema.literal('StopAndQuarantineFile'), _configSchema.schema.literal('RestrictCodeExecution'), _configSchema.schema.literal('UnrestrictCodeExecution')]);
const MachineActionStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('Pending'), _configSchema.schema.literal('InProgress'), _configSchema.schema.literal('Succeeded'), _configSchema.schema.literal('Failed'), _configSchema.schema.literal('TimeOut'), _configSchema.schema.literal('Cancelled')]);
const GetActionsParamsSchema = exports.GetActionsParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  status: _configSchema.schema.maybe(_configSchema.schema.oneOf([MachineActionStatusSchema, _configSchema.schema.arrayOf(MachineActionStatusSchema, {
    minSize: 1
  })])),
  machineId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  type: _configSchema.schema.maybe(_configSchema.schema.oneOf([MachineActionTypeSchema, _configSchema.schema.arrayOf(MachineActionTypeSchema, {
    minSize: 1
  })])),
  requestor: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  creationDateTimeUtc: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1
  })])),
  page: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    defaultValue: 1
  })),
  pageSize: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    max: 1000,
    defaultValue: 20
  })),
  sortField: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  sortDirection: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')]))
});
const GetActionResultsParamsSchema = exports.GetActionResultsParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    minLength: 1
  })
});
const MSDefenderLibraryFileSchema = exports.MSDefenderLibraryFileSchema = _configSchema.schema.object({
  fileName: _configSchema.schema.maybe(_configSchema.schema.string()),
  sha256: _configSchema.schema.maybe(_configSchema.schema.string()),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  creationTime: _configSchema.schema.maybe(_configSchema.schema.string()),
  lastUpdatedTime: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  hasParameters: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  parametersDescription: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string()))
}, {
  unknowns: 'allow'
});
const GetLibraryFilesResponse = exports.GetLibraryFilesResponse = _configSchema.schema.object({
  '@odata.context': _configSchema.schema.maybe(_configSchema.schema.string()),
  value: _configSchema.schema.maybe(_configSchema.schema.arrayOf(MSDefenderLibraryFileSchema))
}, {
  unknowns: 'allow'
});
const DownloadActionResultsResponseSchema = exports.DownloadActionResultsResponseSchema = _configSchema.schema.stream();

// ----------------------------------
// Connector Sub-Actions
// ----------------------------------

const TestConnectorSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.MICROSOFT_DEFENDER_ENDPOINT_SUB_ACTION.TEST_CONNECTOR),
  subActionParams: TestConnectorParamsSchema
});
const IsolateHostSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.MICROSOFT_DEFENDER_ENDPOINT_SUB_ACTION.ISOLATE_HOST),
  subActionParams: IsolateHostParamsSchema
});
const ReleaseHostSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.MICROSOFT_DEFENDER_ENDPOINT_SUB_ACTION.RELEASE_HOST),
  subActionParams: ReleaseHostParamsSchema
});
const RunScriptSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.MICROSOFT_DEFENDER_ENDPOINT_SUB_ACTION.RUN_SCRIPT),
  subActionParams: RunScriptParamsSchema
});
const MicrosoftDefenderEndpointActionParamsSchema = exports.MicrosoftDefenderEndpointActionParamsSchema = _configSchema.schema.oneOf([TestConnectorSchema, IsolateHostSchema, ReleaseHostSchema, RunScriptSchema]);