"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _boundary_form = require("./boundary_form");
var _entity_form = require("./entity_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/geo_containment/rule_form/rule_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RuleForm = props => {
  function getValidationError(key) {
    var _props$errors$key;
    // @ts-expect-error upgrade typescript v5.1.6
    return ((_props$errors$key = props.errors[key]) === null || _props$errors$key === void 0 ? void 0 : _props$errors$key.length) > 0 && key in props.ruleParams ? props.errors[key][0] : null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_entity_form.EntityForm, {
    data: props.data,
    getValidationError: getValidationError,
    ruleParams: props.ruleParams,
    setDataViewId: id => props.setRuleParams('indexId', id),
    setDataViewTitle: title => props.setRuleParams('index', title),
    setDateField: fieldName => props.setRuleParams('dateField', fieldName),
    setEntityField: fieldName => props.setRuleParams('entity', fieldName),
    setGeoField: fieldName => props.setRuleParams('geoField', fieldName),
    setQuery: query => props.setRuleParams('indexQuery', query),
    unifiedSearch: props.unifiedSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_boundary_form.BoundaryForm, {
    data: props.data,
    getValidationError: getValidationError,
    ruleParams: props.ruleParams,
    setDataViewId: id => {
      props.setRuleParams('boundaryIndexId', id);
      // TODO remove unused param 'boundaryType'
      props.setRuleParams('boundaryType', 'entireIndex');
    },
    setDataViewTitle: title => props.setRuleParams('boundaryIndexTitle', title),
    setGeoField: fieldName => props.setRuleParams('boundaryGeoField', fieldName),
    setNameField: fieldName => props.setRuleParams('boundaryNameField', fieldName),
    setQuery: query => props.setRuleParams('boundaryIndexQuery', query),
    unifiedSearch: props.unifiedSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.RuleForm = RuleForm;