"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuspenseErrorBoundary = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/suspense_error_boundary/suspense_error_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class SuspenseErrorBoundary extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      error: null
    });
  }
  static getDerivedStateFromError(error) {
    // Update state so next render shows fallback UI.
    return {
      error
    };
  }
  componentDidCatch(error) {
    const {
      notifications
    } = this.props;
    if (notifications) {
      const title = _i18n.i18n.translate('xpack.spaces.uiApi.errorBoundaryToastTitle', {
        defaultMessage: 'Failed to load Kibana asset'
      });
      const toastMessage = _i18n.i18n.translate('xpack.spaces.uiApi.errorBoundaryToastMessage', {
        defaultMessage: 'Reload page to continue.'
      });
      notifications.toasts.addError(error, {
        title,
        toastMessage
      });
    }
  }
  render() {
    const {
      children,
      notifications,
      showLoadingSpinner = true
    } = this.props;
    const {
      error
    } = this.state;
    if (!notifications || error) {
      return null;
    }
    const fallback = showLoadingSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 43
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: fallback,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 12
      }
    }, children);
  }
}
exports.SuspenseErrorBoundary = SuspenseErrorBoundary;