"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizeSpace = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _space_avatar = require("../../../space_avatar");
var _lib = require("../../lib");
var _section_panel = require("../section_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/components/customize_space/customize_space.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CustomizeSpace extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      customizingAvatar: false,
      usingCustomIdentifier: false
    });
    (0, _defineProperty2.default)(this, "onNameChange", e => {
      if (!this.props.space) {
        return;
      }
      const canUpdateId = !this.props.editingExistingSpace && !this.state.usingCustomIdentifier;
      let {
        id
      } = this.props.space;
      if (canUpdateId) {
        id = (0, _lib.toSpaceIdentifier)(e.target.value);
      }
      this.props.onChange({
        ...this.props.space,
        name: e.target.value,
        id,
        initials: this.props.space.customAvatarInitials ? this.props.space.initials : (0, _space_avatar.getSpaceInitials)({
          name: e.target.value
        }),
        color: this.props.space.customAvatarColor ? this.props.space.color : (0, _space_avatar.getSpaceColor)({
          name: e.target.value
        })
      });
    });
    (0, _defineProperty2.default)(this, "onDescriptionChange", e => {
      this.props.onChange({
        ...this.props.space,
        description: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onSpaceIdentifierChange", e => {
      const updatedIdentifier = e.target.value;
      const usingCustomIdentifier = updatedIdentifier !== (0, _lib.toSpaceIdentifier)(this.props.space.name);
      this.setState({
        usingCustomIdentifier
      });
      this.props.onChange({
        ...this.props.space,
        id: (0, _lib.toSpaceIdentifier)(updatedIdentifier)
      });
    });
    (0, _defineProperty2.default)(this, "onAvatarChange", space => {
      this.props.onChange(space);
    });
  }
  render() {
    var _this$props$space$id;
    const {
      validator,
      editingExistingSpace,
      space,
      title
    } = this.props;
    const {
      name = '',
      description = ''
    } = space;
    return /*#__PURE__*/_react.default.createElement(_section_panel.SectionPanel, {
      title: title,
      dataTestSubj: "generalPanel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.manageSpacePage.describeSpaceTitle",
        defaultMessage: "Describe this space",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 17
        }
      }))),
      description: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.describeSpaceDescription', {
        defaultMessage: 'Give your space a meaningful name and description.'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      label: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.nameFormRowLabel', {
        defaultMessage: 'Name'
      })
    }, validator.validateSpaceName(this.props.space), {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "name",
      "data-test-subj": "addSpaceName",
      value: name !== null && name !== void 0 ? name : '',
      onChange: this.onNameChange,
      isInvalid: validator.validateSpaceName(this.props.space).isInvalid,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      "data-test-subj": "optionalDescription",
      label: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.spaceDescriptionFormRowLabel', {
        defaultMessage: 'Description'
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.manageSpacePage.optionalLabel",
        defaultMessage: "Optional",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 17
        }
      })),
      helpText: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.spaceDescriptionHelpText', {
        defaultMessage: 'Appears on the space selection screen and spaces list.'
      })
    }, validator.validateSpaceDescription(this.props.space), {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      "data-test-subj": "descriptionSpaceText",
      name: "description",
      value: description !== null && description !== void 0 ? description : '',
      onChange: this.onDescriptionChange,
      isInvalid: validator.validateSpaceDescription(this.props.space).isInvalid,
      fullWidth: true,
      rows: 2,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.spaceIdentifier.urlIdentifierTitle",
        defaultMessage: "URL identifier",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 15
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.spaceIdentifier.kibanaURLForSpaceIdentifierDescription",
        defaultMessage: "You can't change the URL identifier once created.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 15
        }
      })
    }, this.props.validator.validateURLIdentifier(this.props.space), {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "spaceURLDisplay",
      value: (_this$props$space$id = this.props.space.id) !== null && _this$props$space$id !== void 0 ? _this$props$space$id : '',
      onChange: this.onSpaceIdentifierChange,
      isInvalid: this.props.validator.validateURLIdentifier(this.props.space).isInvalid,
      disabled: editingExistingSpace,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }))));
  }
}
exports.CustomizeSpace = CustomizeSpace;