"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/components/confirm_delete_modal/confirm_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmDeleteModal = ({
  space,
  onSuccess,
  onCancel,
  spacesManager
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    value: isCurrentSpace
  } = (0, _useAsync.default)(async () => space.id === (await spacesManager.getActiveSpace()).id, [space.id]);
  const [state, deleteSpace] = (0, _useAsyncFn.default)(async () => {
    try {
      await spacesManager.deleteSpace(space);
      services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.successMessage', {
        defaultMessage: "Deleted space ''{name}''",
        values: {
          name: space.name
        }
      }));
      if (isCurrentSpace) {
        spacesManager.redirectToSpaceSelector();
      } else {
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      }
    } catch (error) {
      var _body;
      services.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.errorMessage', {
          defaultMessage: "Could not delete space ''{name}''",
          values: {
            name: space.name
          }
        }),
        text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
      });
    }
  }, [isCurrentSpace]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.title', {
      defaultMessage: "Delete space ''{name}''?",
      values: {
        name: space.name
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: deleteSpace,
    cancelButtonText: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.confirmButton', {
      defaultMessage: '{isLoading, select, true{Deleting space and all contents…} other{Delete space and all contents}}',
      values: {
        isLoading: state.loading
      }
    }),
    buttonColor: "danger",
    isLoading: state.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, isCurrentSpace && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.currentSpaceTitle', {
      defaultMessage: 'You are currently in this space.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmDeleteModal.currentSpaceDescription",
    defaultMessage: "Once deleted, you must choose a different space.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmDeleteModal.description",
    defaultMessage: "This space and {allContents} will be permanently deleted.",
    values: {
      allContents: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.confirmDeleteModal.allContents",
        defaultMessage: "all contents",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmDeleteModal.cannotUndoWarning",
    defaultMessage: "You can't recover deleted spaces.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }))));
};
exports.ConfirmDeleteModal = ConfirmDeleteModal;