"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _components = require("../../components");
var _constants = require("../../constants");
var _app_context = require("../../app_context");
var _navigation = require("../../services/navigation");
var _http = require("../../services/http");
var _lib = require("../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/repository_edit/repository_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RepositoryEdit = ({
  history
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    name
  } = (0, _lib.useDecodedParams)();
  const section = 'repositories';

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs('repositoryEdit');
    _navigation.docTitleService.setTitle('repositoryEdit');
  }, []);

  // Repository state with default empty repository
  const [repository, setRepository] = (0, _react.useState)({
    name: '',
    type: null,
    settings: {}
  });

  // Load repository
  const {
    error: repositoryError,
    isLoading: loadingRepository,
    data: repositoryData
  } = (0, _http.useLoadRepository)(name);

  // Update repository state when data is loaded
  (0, _react.useEffect)(() => {
    if (repositoryData && repositoryData.repository) {
      setRepository(repositoryData.repository);
    }
  }, [repositoryData]);

  // Saving repository states
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);

  // Save repository
  const onSave = async editedRepository => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _http.editRepository)(editedRepository);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
    } else {
      history.push(encodeURI(`${_constants.BASE_PATH}/${encodeURIComponent(section)}/${encodeURIComponent(name)}`));
    }
  };
  const renderLoading = () => {
    return /*#__PURE__*/_react.default.createElement(_components.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editRepository.loadingRepositoryDescription",
      defaultMessage: "Loading repository details\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }));
  };
  const renderError = () => {
    const notFound = repositoryError.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.editRepository.repositoryNotFoundErrorMessage', {
          defaultMessage: `The repository ''{name}'' does not exist.`,
          values: {
            name
          }
        })
      }
    } : repositoryError;
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.editRepository.loadingRepositoryErrorTitle",
        defaultMessage: "Error loading repository details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }),
      error: errorObject,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    });
  };
  if (loadingRepository) {
    return renderLoading();
  }
  if (repositoryError) {
    return renderError();
  }
  const {
    isManagedRepository
  } = repositoryData;
  const clearSaveError = () => {
    setSaveError(null);
  };
  const renderSaveError = () => {
    return saveError ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.editRepository.savingRepositoryErrorTitle",
        defaultMessage: "Cannot save repository",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 11
        }
      }),
      error: saveError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }) : null;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editRepositoryTitle",
      defaultMessage: "Edit repository",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), isManagedRepository ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editRepository.managedRepositoryWarningTitle",
      defaultMessage: "This is a managed repository. Changing this repository might affect other systems that use it. Proceed with caution.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_components.RepositoryForm, {
    repository: repository,
    isManagedRepository: isManagedRepository,
    isEditing: true,
    isSaving: isSaving,
    saveError: renderSaveError(),
    clearSaveError: clearSaveError,
    onSave: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }));
};
exports.RepositoryEdit = RepositoryEdit;