"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotFeatureStatesSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _collapsible_lists = require("../../collapsible_lists");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/summaries/snapshots/snapshot_feature_states_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SnapshotFeatureStatesSummary = ({
  featureStates
}) => {
  // When a policy that includes featureStates: ['none'] is executed, the resulting
  // snapshot wont include the `none` in the featureStates array but instead will
  // return an empty array.
  const hasNoFeatureStates = !featureStates || featureStates.length === 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "snapshotFeatureStatesSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.summary.snapshotFeatureStatesLabel",
    defaultMessage: "Include feature state {hasSpecificFeatures, plural, one {from} other {}}",
    values: {
      hasSpecificFeatures: !hasNoFeatureStates ? 1 : 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, hasNoFeatureStates ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.summary.snapshotNoFeatureStatesLabel",
    defaultMessage: "No",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_collapsible_lists.CollapsibleFeatureStatesList, {
    featureStates: featureStates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }))));
};
exports.SnapshotFeatureStatesSummary = SnapshotFeatureStatesSummary;