"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storeSloSettings = exports.getSummaryIndices = exports.getSloSettings = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../common/constants");
var _get_slo_summary_indices = require("../../common/get_slo_summary_indices");
var _slo_settings = require("../saved_objects/slo_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloSettings = async soClient => {
  try {
    var _soObject$attributes$;
    const soObject = await soClient.get(_slo_settings.SO_SLO_SETTINGS_TYPE, (0, _slo_settings.sloSettingsObjectId)(soClient.getCurrentNamespace()));
    // set if it's not there
    soObject.attributes.staleThresholdInHours = (_soObject$attributes$ = soObject.attributes.staleThresholdInHours) !== null && _soObject$attributes$ !== void 0 ? _soObject$attributes$ : 2;
    return _sloSchema.sloSettingsSchema.encode(soObject.attributes);
  } catch (e) {
    if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
      return {
        useAllRemoteClusters: false,
        selectedRemoteClusters: [],
        staleThresholdInHours: _constants.DEFAULT_STALE_SLO_THRESHOLD_HOURS
      };
    }
    throw e;
  }
};
exports.getSloSettings = getSloSettings;
const storeSloSettings = async (soClient, params) => {
  const object = await soClient.create(_slo_settings.SO_SLO_SETTINGS_TYPE, _sloSchema.sloSettingsSchema.encode(params), {
    id: (0, _slo_settings.sloSettingsObjectId)(soClient.getCurrentNamespace()),
    overwrite: true
  });
  return _sloSchema.sloSettingsSchema.encode(object.attributes);
};
exports.storeSloSettings = storeSloSettings;
const getSummaryIndices = async (esClient, settings) => {
  const {
    useAllRemoteClusters,
    selectedRemoteClusters
  } = settings;
  // If remote clusters are not used, we don't need to fetch the remote cluster info
  if (useAllRemoteClusters || !useAllRemoteClusters && selectedRemoteClusters.length === 0) {
    return {
      indices: (0, _get_slo_summary_indices.getSLOSummaryIndices)(settings)
    };
  }
  const clustersByName = await esClient.cluster.remoteInfo();
  const clusterNames = clustersByName && Object.keys(clustersByName) || [];
  const clusterInfo = clusterNames.map(clusterName => ({
    name: clusterName,
    isConnected: clustersByName[clusterName].connected
  }));
  return {
    indices: (0, _get_slo_summary_indices.getSLOSummaryIndices)(settings, clusterInfo)
  };
};
exports.getSummaryIndices = getSummaryIndices;