"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.slo = exports.SO_SLO_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateSlo890 = doc => {
  const {
    timeWindow,
    ...other
  } = doc.attributes;
  return {
    ...doc,
    attributes: {
      ...other,
      timeWindow: {
        duration: timeWindow.duration,
        type: timeWindow.isCalendar ? 'calendarAligned' : 'rolling'
      }
    }
  };
};
const SO_SLO_TYPE = exports.SO_SLO_TYPE = 'slo';
const slo = exports.slo = {
  name: SO_SLO_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  modelVersions: {
    1: {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          version: {
            type: 'long'
          }
        }
      }, {
        type: 'data_backfill',
        backfillFn: doc => {
          var _doc$attributes$versi;
          // we explicitely set the version to 1, so we know which SLOs requires a migration to the following version.
          return {
            attributes: {
              version: (_doc$attributes$versi = doc.attributes.version) !== null && _doc$attributes$versi !== void 0 ? _doc$attributes$versi : 1
            }
          };
        }
      }]
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      name: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      indicator: {
        properties: {
          type: {
            type: 'keyword'
          },
          params: {
            type: 'flattened'
          }
        }
      },
      budgetingMethod: {
        type: 'keyword'
      },
      enabled: {
        type: 'boolean'
      },
      tags: {
        type: 'keyword'
      },
      version: {
        type: 'long'
      }
    }
  },
  management: {
    displayName: 'SLO',
    importableAndExportable: false,
    getTitle(sloSavedObject) {
      return `SLO: [${sloSavedObject.attributes.name}]`;
    }
  },
  migrations: {
    '8.9.0': migrateSlo890
  }
};