"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkPurgeRollupRoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
var _bulk_purge_rollup_data = require("../../services/bulk_purge_rollup_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkPurgeRollupRoute = exports.bulkPurgeRollupRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/_bulk_purge_rollup 2023-10-31',
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.bulkPurgeRollupSchema,
  handler: async ({
    request,
    context,
    params,
    logger,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      repository,
      scopedClusterClient
    } = await getScopedClients({
      request,
      logger
    });
    const purgeRollupData = new _bulk_purge_rollup_data.BulkPurgeRollupData(scopedClusterClient.asCurrentUser, repository);
    return purgeRollupData.execute(params.body);
  }
});