"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleSLOView = ToggleSLOView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _sort_by_select = require("./common/sort_by_select");
var _slo_list_group_by = require("./slo_list_group_by");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/toggle_slo_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const toggleButtonsIcons = [{
  id: `cardView`,
  label: 'Card View',
  iconType: 'apps',
  'data-test-subj': 'sloCardViewButton'
}, {
  id: `listView`,
  label: 'List View',
  iconType: 'list',
  'data-test-subj': 'sloListViewButton'
}, {
  iconType: 'tableDensityCompact',
  id: 'compactView',
  label: _i18n.i18n.translate('xpack.slo.listView.compactViewLabel', {
    defaultMessage: 'Compact view'
  })
}];
function ToggleSLOView({
  view,
  onChangeView,
  onStateChange,
  sloList,
  state,
  loading
}) {
  var _sloList$total, _sloList$perPage, _sloList$page;
  const total = (_sloList$total = sloList === null || sloList === void 0 ? void 0 : sloList.total) !== null && _sloList$total !== void 0 ? _sloList$total : 0;
  const pageSize = (_sloList$perPage = sloList === null || sloList === void 0 ? void 0 : sloList.perPage) !== null && _sloList$perPage !== void 0 ? _sloList$perPage : 0;
  const pageIndex = (_sloList$page = sloList === null || sloList === void 0 ? void 0 : sloList.page) !== null && _sloList$page !== void 0 ? _sloList$page : 1;
  const rangeStart = total === 0 ? 0 : pageSize * (pageIndex - 1) + 1;
  const rangeEnd = Math.min(total, pageSize * (pageIndex - 1) + pageSize);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, (!state.groupBy || state.groupBy === 'ungrouped') && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overview.pagination.description",
    defaultMessage: "Showing {currentCount} of {total} {slos}",
    values: {
      currentCount: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 31
        }
      }, `${rangeStart}-${rangeEnd}`),
      total,
      slos: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.slo.overview.slos.label",
        defaultMessage: "SLOs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 21
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sort_by_select.SLOSortBy, {
    state: state,
    onStateChange: onStateChange,
    loading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_list_group_by.SloGroupBy, {
    state: state,
    onStateChange: onStateChange,
    loading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.slo.toggleSLOView.euiButtonGroup.sloView', {
      defaultMessage: 'SLO View'
    }),
    options: toggleButtonsIcons,
    idSelected: view,
    onChange: id => onChangeView(id),
    isIconOnly: true,
    isDisabled: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })));
}