"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickFilters = QuickFilters;
exports.getSelectedOptions = void 0;
var _react = require("@emotion/react");
var _public = require("@kbn/controls-plugin/public");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/common/quick_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function QuickFilters({
  dataView,
  initialState: {
    tagsFilter,
    statusFilter
  },
  onStateChange
}) {
  const [controlGroupAPI, setControlGroupAPI] = (0, _react2.useState)();
  (0, _react2.useEffect)(() => {
    if (!controlGroupAPI) {
      return;
    }
    const subscription = controlGroupAPI.filters$.pipe((0, _rxjs.skip)(1)).subscribe((newFilters = []) => {
      if (newFilters.length === 0) {
        onStateChange({
          tagsFilter: undefined,
          statusFilter: undefined
        });
      } else {
        var _newFilters$filter, _newFilters$filter2;
        onStateChange({
          tagsFilter: (_newFilters$filter = newFilters.filter(filter => filter.meta.key === 'slo.tags')) === null || _newFilters$filter === void 0 ? void 0 : _newFilters$filter[0],
          statusFilter: (_newFilters$filter2 = newFilters.filter(filter => filter.meta.key === 'status')) === null || _newFilters$filter2 === void 0 ? void 0 : _newFilters$filter2[0]
        });
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroupAPI, onStateChange]);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        .controlsWrapper {
          align-items: flex-start;
          min-height: initial;
        }
        .controlPanel {
          height: initial;
        }
        .controlGroup {
          min-height: initial;
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_public.ControlGroupRenderer, {
    onApiAvailable: setControlGroupAPI,
    getCreationOptions: async (initialState, builder) => {
      var _statusFilter$meta, _statusFilter$query, _statusFilter$query$e, _statusFilter$meta2, _tagsFilter$query, _tagsFilter$query$exi;
      builder.addOptionsListControl(initialState, {
        dataViewId: dataView.id,
        fieldName: 'status',
        width: 'small',
        grow: true,
        title: STATUS_LABEL,
        exclude: statusFilter === null || statusFilter === void 0 ? void 0 : (_statusFilter$meta = statusFilter.meta) === null || _statusFilter$meta === void 0 ? void 0 : _statusFilter$meta.negate,
        selectedOptions: getSelectedOptions(statusFilter),
        existsSelected: Boolean((statusFilter === null || statusFilter === void 0 ? void 0 : (_statusFilter$query = statusFilter.query) === null || _statusFilter$query === void 0 ? void 0 : (_statusFilter$query$e = _statusFilter$query.exists) === null || _statusFilter$query$e === void 0 ? void 0 : _statusFilter$query$e.field) === 'status'),
        placeholder: ALL_LABEL
      }, 'slo-status-filter');
      builder.addOptionsListControl(initialState, {
        dataViewId: dataView.id,
        title: TAGS_LABEL,
        fieldName: 'slo.tags',
        width: 'small',
        grow: false,
        selectedOptions: getSelectedOptions(tagsFilter),
        exclude: statusFilter === null || statusFilter === void 0 ? void 0 : (_statusFilter$meta2 = statusFilter.meta) === null || _statusFilter$meta2 === void 0 ? void 0 : _statusFilter$meta2.negate,
        existsSelected: Boolean((tagsFilter === null || tagsFilter === void 0 ? void 0 : (_tagsFilter$query = tagsFilter.query) === null || _tagsFilter$query === void 0 ? void 0 : (_tagsFilter$query$exi = _tagsFilter$query.exists) === null || _tagsFilter$query$exi === void 0 ? void 0 : _tagsFilter$query$exi.field) === 'slo.tags'),
        placeholder: ALL_LABEL
      }, 'slo-tags-filter');
      return {
        initialState
      };
    },
    timeRange: {
      from: 'now-24h',
      to: 'now'
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
}
const getSelectedOptions = filter => {
  var _filter$meta, _filter$query, _filter$query$match_p, _filter$query2, _filter$query2$match_;
  if ((0, _lodash.isEmpty)(filter)) {
    return [];
  }
  if (filter !== null && filter !== void 0 && (_filter$meta = filter.meta) !== null && _filter$meta !== void 0 && _filter$meta.params && Array.isArray(filter === null || filter === void 0 ? void 0 : filter.meta.params)) {
    return filter === null || filter === void 0 ? void 0 : filter.meta.params;
  }
  if (filter !== null && filter !== void 0 && (_filter$query = filter.query) !== null && _filter$query !== void 0 && (_filter$query$match_p = _filter$query.match_phrase) !== null && _filter$query$match_p !== void 0 && _filter$query$match_p.status) {
    return [filter.query.match_phrase.status];
  }
  if (filter !== null && filter !== void 0 && (_filter$query2 = filter.query) !== null && _filter$query2 !== void 0 && (_filter$query2$match_ = _filter$query2.match_phrase) !== null && _filter$query2$match_ !== void 0 && _filter$query2$match_['slo.tags']) {
    var _filter$query$match_p2;
    return [filter === null || filter === void 0 ? void 0 : (_filter$query$match_p2 = filter.query.match_phrase) === null || _filter$query$match_p2 === void 0 ? void 0 : _filter$query$match_p2['slo.tags']];
  }
  return [];
};
exports.getSelectedOptions = getSelectedOptions;
const TAGS_LABEL = _i18n.i18n.translate('xpack.slo.list.tags', {
  defaultMessage: 'Tags'
});
const STATUS_LABEL = _i18n.i18n.translate('xpack.slo.list.status', {
  defaultMessage: 'Status'
});
const ALL_LABEL = _i18n.i18n.translate('xpack.slo.list.all', {
  defaultMessage: 'All'
});