"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOCardItemInstanceBadge = SLOCardItemInstanceBadge;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _slo_groupings = require("../common/slo_groupings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/card_view/slo_card_item_instance_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SLOCardItemInstanceBadge({
  slo
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const entries = Object.entries(slo.groupings);
  const show = entries.length > 1;
  if (!show) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      onMouseDown: e => {
        e.stopPropagation(); // stops propagation of metric onElementClick
      },
      onClickAriaLabel: _i18n.i18n.translate('xpack.slo.instances.seeAllBadge', {
        defaultMessage: 'see all instance ids'
      }),
      "data-test-subj": "o11ySlosSeeAllInstanceIdsBadge",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 11
      }
    }, `${_i18n.i18n.translate('xpack.slo.extraInstanceIds.badge', {
      defaultMessage: '+{count, plural, one {# instance} other {# instances}}',
      values: {
        count: entries.length - 1
      }
    })}`),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    onMouseDownCapture: e => e.stopPropagation(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
    slo: slo,
    direction: "column",
    truncate: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))));
}